/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.cache.AvailableMemoryCalculator;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapLongArray;

public interface LongArrayFactory {
    public static final LongArrayFactory HEAP = new LongArrayFactory(){

        @Override
        public LongArray newLongArray(long length) {
            return new HeapLongArray(length);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize) {
            return new DynamicLongArray(this, chunkSize);
        }
    };
    public static final LongArrayFactory OFF_HEAP = new LongArrayFactory(){

        @Override
        public LongArray newLongArray(long length) {
            return new OffHeapLongArray(length);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize) {
            return new DynamicLongArray(this, chunkSize);
        }
    };
    public static final LongArrayFactory AUTO = new AutoLongArrayFactory(AvailableMemoryCalculator.RUNTIME, 314572800L);

    public LongArray newLongArray(long var1);

    public LongArray newDynamicLongArray(long var1);

    public static class AutoLongArrayFactory
    implements LongArrayFactory {
        private final AvailableMemoryCalculator calculator;
        private final long margin;

        public AutoLongArrayFactory(AvailableMemoryCalculator calculator, long margin) {
            this.calculator = calculator;
            this.margin = margin;
        }

        @Override
        public LongArray newLongArray(long length) {
            long bytesRequired = length * 8L;
            long freeHeap = this.calculator.availableHeapMemory() - this.margin;
            if (bytesRequired < Integer.MAX_VALUE && bytesRequired < freeHeap) {
                return HEAP.newLongArray(length);
            }
            long freeOffHeap = this.calculator.availableOffHeapMemory() - this.margin;
            if (bytesRequired < freeOffHeap) {
                return OFF_HEAP.newLongArray(length);
            }
            if (bytesRequired < freeHeap + freeOffHeap) {
                return this.newDynamicLongArray(length / 10L);
            }
            throw new IllegalArgumentException(String.format("Neither enough free heap (%d), nor off-heap (%d) space for allocating %s", freeHeap, freeOffHeap, Format.bytes(bytesRequired)));
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize) {
            return new DynamicLongArray(this, chunkSize);
        }
    }
}

