/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class CompareTxStreams {
    public static void main(String[] args) throws IOException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        Monitors monitors = new Monitors();
        CompareTxStreams.compareLogStreams(LogExtractor.from(fileSystem, XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

            @Override
            public XaCommandWriter newInstance() {
                return new PhysicalLogNeoXaCommandWriter();
            }
        }, monitors.newMonitor(ByteCounterMonitor.class, new String[0]), new LogEntryWriterv1(), new File(args[0])), LogExtractor.from(fileSystem, XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

            @Override
            public XaCommandWriter newInstance() {
                return new PhysicalLogNeoXaCommandWriter();
            }
        }, monitors.newMonitor(ByteCounterMonitor.class, new String[0]), new LogEntryWriterv1(), new File(args[1])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void compareLogStreams(LogExtractor extractor1, LogExtractor extractor2) throws IOException {
        try {
            boolean branchingDetected = false;
            long lastTx = 1L;
            while (true) {
                long tx2;
                long tx1;
                if ((tx1 = extractor1.extractNext(new InMemoryLogBuffer())) != (tx2 = extractor2.extractNext(new InMemoryLogBuffer()))) {
                    throw new RuntimeException("Differing tx " + tx1 + " and " + tx2);
                }
                if (tx1 == -1L || tx2 == -1L) break;
                lastTx = tx1;
                if (!branchingDetected) {
                    if (extractor1.getLastStartEntry().getMasterId() == extractor2.getLastStartEntry().getMasterId() && extractor1.getLastTxChecksum() == extractor2.getLastTxChecksum()) continue;
                    branchingDetected = true;
                    System.out.println("Branch at " + tx1 + ": masters:" + extractor1.getLastStartEntry().getMasterId() + "," + extractor2.getLastStartEntry().getMasterId() + " checksums:" + extractor1.getLastTxChecksum() + "," + extractor2.getLastTxChecksum());
                    continue;
                }
                if (extractor1.getLastStartEntry().getMasterId() == extractor2.getLastStartEntry().getMasterId() && extractor1.getLastTxChecksum() == extractor2.getLastTxChecksum()) {
                    branchingDetected = false;
                    System.out.println("Merged again at " + tx1);
                    continue;
                }
                System.out.println("Still branched at " + tx1 + ": masters:" + extractor1.getLastStartEntry().getMasterId() + "," + extractor2.getLastStartEntry().getMasterId() + " checksums:" + extractor1.getLastTxChecksum() + "," + extractor2.getLastTxChecksum());
            }
            System.out.println("Last tx " + lastTx);
        }
        finally {
            CompareTxStreams.closeExtractor(extractor1);
            CompareTxStreams.closeExtractor(extractor2);
        }
    }

    private static void closeExtractor(LogExtractor extractor) {
        if (extractor != null) {
            extractor.close();
        }
    }
}

