/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.util.Consumer;

class TranslatingEntryConsumer
implements Consumer<LogEntry, IOException> {
    private LogEntry.Start startEntry;
    private LogHandler handler;
    private int xidIdentifier;
    private List<LogEntry> entries;
    private final Function<List<LogEntry>, List<LogEntry>> translator;

    TranslatingEntryConsumer(Function<List<LogEntry>, List<LogEntry>> translator) {
        this.translator = translator;
    }

    @Override
    public boolean accept(LogEntry logEntry) throws IOException {
        if (this.startEntry == null) {
            if (logEntry == null || logEntry.getType() != 1) {
                throw new IOException("Unable to find start entry");
            }
            this.startEntry = (LogEntry.Start)logEntry;
        }
        logEntry.reset(this.xidIdentifier);
        if (logEntry.getVersion() != -1) {
            if (this.entries == null) {
                this.entries = new LinkedList<LogEntry>();
            }
            this.entries.add(logEntry);
            if (logEntry.getType() == 5 || logEntry.getType() == 6) {
                this.entries = this.translator.apply(this.entries);
            }
            if (logEntry.getType() == 4) {
                for (LogEntry entry : this.entries) {
                    entry.accept(this.handler);
                }
                this.entries = null;
            }
        } else {
            logEntry.accept(this.handler);
        }
        return true;
    }

    public TranslatingEntryConsumer bind(int xidIdentifier, LogHandler handler) {
        this.xidIdentifier = xidIdentifier;
        this.handler = handler;
        this.entries = null;
        return this;
    }
}

