/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class LogEntryWriterv1
implements LogEntryWriter {
    private static final short CURRENT_FORMAT_VERSION = 4;
    static final int LOG_HEADER_SIZE = 16;
    private XaCommandWriter commandWriter;

    public static ByteBuffer writeLogHeader(ByteBuffer buffer, long logVersion, long previousCommittedTxId) {
        buffer.clear();
        buffer.putLong(logVersion | 0x400000000000000L);
        buffer.putLong(previousCommittedTxId);
        buffer.flip();
        return buffer;
    }

    @Override
    public void writeLogEntry(LogEntry entry, LogBuffer buffer) throws IOException {
        if (entry.getVersion() == -1) {
            buffer.put(entry.getVersion());
        }
        switch (entry.getType()) {
            case 1: {
                this.writeStart(entry.getIdentifier(), ((LogEntry.Start)entry).getXid(), ((LogEntry.Start)entry).getMasterId(), ((LogEntry.Start)entry).getLocalId(), ((LogEntry.Start)entry).getTimeWritten(), ((LogEntry.Start)entry).getLastCommittedTxWhenTransactionStarted(), buffer);
                break;
            }
            case 3: {
                this.writeCommand(entry.getIdentifier(), ((LogEntry.Command)entry).getXaCommand(), buffer);
                break;
            }
            case 2: {
                this.writePrepare(entry.getIdentifier(), ((LogEntry.Prepare)entry).getTimeWritten(), buffer);
                break;
            }
            case 5: {
                LogEntry.Commit commit1PC = (LogEntry.Commit)entry;
                this.writeCommit(false, commit1PC.getIdentifier(), commit1PC.getTxId(), ((LogEntry.OnePhaseCommit)entry).getTimeWritten(), buffer);
                break;
            }
            case 6: {
                LogEntry.Commit commit2PC = (LogEntry.Commit)entry;
                this.writeCommit(true, commit2PC.getIdentifier(), commit2PC.getTxId(), ((LogEntry.TwoPhaseCommit)entry).getTimeWritten(), buffer);
                break;
            }
            case 4: {
                this.writeDone(entry.getIdentifier(), buffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown entry type " + entry.getType());
            }
        }
    }

    private void writePrepare(int identifier, long timeWritten, LogBuffer logBuffer) throws IOException {
        logBuffer.put((byte)2).putInt(identifier).putLong(timeWritten);
    }

    private void writeCommit(boolean twoPhase, int identifier, long txId, long timeWritten, LogBuffer logBuffer) throws IOException {
        logBuffer.put(twoPhase ? (byte)6 : 5).putInt(identifier).putLong(txId).putLong(timeWritten);
    }

    private void writeDone(int identifier, LogBuffer logBuffer) throws IOException {
        logBuffer.put((byte)4).putInt(identifier);
    }

    private void writeStart(int identifier, Xid xid, int masterId, int myId, long timeWritten, long latestCommittedTxWhenStarted, LogBuffer logBuffer) throws IOException {
        byte[] globalId = xid.getGlobalTransactionId();
        byte[] branchId = xid.getBranchQualifier();
        int formatId = xid.getFormatId();
        logBuffer.put((byte)1).put((byte)globalId.length).put((byte)branchId.length).put(globalId).put(branchId).putInt(identifier).putInt(formatId).putInt(masterId).putInt(myId).putLong(timeWritten).putLong(latestCommittedTxWhenStarted);
    }

    private void writeCommand(int identifier, XaCommand command, LogBuffer logBuffer) throws IOException {
        logBuffer.put((byte)3).putInt(identifier);
        this.commandWriter.write(command, logBuffer);
    }

    public void setCommandWriter(XaCommandWriter commandWriter) {
        this.commandWriter = commandWriter;
    }
}

