/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.nioneo.xa.PropertyCreator;
import org.neo4j.kernel.impl.nioneo.xa.PropertyDeleter;
import org.neo4j.kernel.impl.nioneo.xa.PropertyTraverser;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccess;
import org.neo4j.kernel.impl.nioneo.xa.RecordChangeSet;
import org.neo4j.kernel.impl.nioneo.xa.RecordChanges;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipCreator;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipDeleter;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipGroupGetter;
import org.neo4j.kernel.impl.nioneo.xa.TokenCreator;
import org.neo4j.kernel.impl.nioneo.xa.TransactionalRelationshipLocker;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.CommandSet;
import org.neo4j.kernel.impl.util.ArrayMap;

public class NeoStoreTransactionContext {
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter relationshipDeleter;
    private final NeoStoreTransactionContextSupplier supplier;
    private final PropertyTraverser propertyTraverser;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;
    private final TransactionalRelationshipLocker locker;
    private final RelationshipGroupGetter relationshipGroupGetter;
    private TransactionState txState;
    private final RecordChangeSet recordChangeSet;
    private final CommandSet commandSet;
    private final NeoStore neoStore;

    public NeoStoreTransactionContext(NeoStoreTransactionContextSupplier supplier, NeoStore neoStore) {
        this.supplier = supplier;
        this.neoStore = neoStore;
        this.recordChangeSet = new RecordChangeSet(neoStore);
        this.commandSet = new CommandSet();
        this.locker = new TransactionalRelationshipLocker();
        this.relationshipGroupGetter = new RelationshipGroupGetter(neoStore.getRelationshipGroupStore());
        this.propertyTraverser = new PropertyTraverser();
        this.propertyCreator = new PropertyCreator(neoStore.getPropertyStore(), this.propertyTraverser);
        this.propertyDeleter = new PropertyDeleter(neoStore.getPropertyStore(), this.propertyTraverser);
        this.relationshipCreator = new RelationshipCreator(this.locker, this.relationshipGroupGetter, neoStore.getDenseNodeThreshold());
        this.relationshipDeleter = new RelationshipDeleter(this.locker, this.relationshipGroupGetter, this.propertyDeleter);
    }

    public ArrayMap<Integer, DefinedProperty> relationshipDelete(long relId) {
        return this.relationshipDeleter.relDelete(relId, this.recordChangeSet);
    }

    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.relationshipCreator.relationshipCreate(id, typeId, startNodeId, endNodeId, this.recordChangeSet);
    }

    public Collection<NodeRecord> getUpgradedDenseNodes() {
        return this.relationshipCreator.getUpgradedDenseNodes();
    }

    public void commitCows() {
        this.txState.commitCows();
    }

    public void updateFirstRelationships() {
        for (RecordAccess.RecordProxy recordProxy : ((RecordChanges)this.recordChangeSet.getNodeRecords()).changes()) {
            NodeRecord record = (NodeRecord)recordProxy.forReadingLinkage();
            this.txState.setFirstIds(record.getId(), record.getNextRel(), record.getNextProp());
        }
    }

    public ArrayMap<Integer, DefinedProperty> getAndDeletePropertyChain(NodeRecord nodeRecord) {
        return this.propertyDeleter.getAndDeletePropertyChain(nodeRecord, this.recordChangeSet.getPropertyRecords());
    }

    public <T extends PrimitiveRecord> void removeProperty(RecordAccess.RecordProxy<Long, T, Void> primitiveProxy, int propertyKey) {
        this.propertyDeleter.removeProperty(primitiveProxy, propertyKey, this.getPropertyRecords());
    }

    public <P extends PrimitiveRecord> void primitiveChangeProperty(RecordAccess.RecordProxy<Long, P, Void> primitive, int propertyKey, Object value) {
        this.propertyCreator.primitiveChangeProperty(primitive, propertyKey, value, this.getPropertyRecords());
    }

    public <P extends PrimitiveRecord> void primitiveAddProperty(RecordAccess.RecordProxy<Long, P, Void> primitive, int propertyKey, Object value) {
        this.propertyCreator.primitiveAddProperty(primitive, propertyKey, value, this.getPropertyRecords());
    }

    public void createPropertyKeyToken(String name, int id) {
        TokenCreator<PropertyKeyTokenRecord> creator = new TokenCreator<PropertyKeyTokenRecord>(this.neoStore.getPropertyKeyTokenStore());
        creator.createToken(name, id, this.getPropertyKeyTokenRecords());
    }

    public void createLabelToken(String name, int id) {
        TokenCreator<LabelTokenRecord> creator = new TokenCreator<LabelTokenRecord>(this.neoStore.getLabelTokenStore());
        creator.createToken(name, id, this.getLabelTokenRecords());
    }

    public void createRelationshipTypeToken(String name, int id) {
        TokenCreator<RelationshipTypeTokenRecord> creator = new TokenCreator<RelationshipTypeTokenRecord>(this.neoStore.getRelationshipTypeStore());
        creator.createToken(name, id, this.getRelationshipTypeTokenRecords());
    }

    public void bind(TransactionState txState) {
        this.txState = txState;
        this.locker.setLockClient(txState.locks());
    }

    public void close() {
        this.recordChangeSet.close();
        this.commandSet.close();
        this.locker.setLockClient(null);
        this.txState = null;
        this.supplier.release(this);
    }

    public Map<Long, Command.NodeCommand> getNodeCommands() {
        return this.commandSet.getNodeCommands();
    }

    public ArrayList<Command.PropertyCommand> getPropCommands() {
        return this.commandSet.getPropCommands();
    }

    public ArrayList<Command.RelationshipCommand> getRelCommands() {
        return this.commandSet.getRelCommands();
    }

    public ArrayList<Command.SchemaRuleCommand> getSchemaRuleCommands() {
        return this.commandSet.getSchemaRuleCommands();
    }

    public ArrayList<Command.RelationshipTypeTokenCommand> getRelationshipTypeTokenCommands() {
        return this.commandSet.getRelationshipTypeTokenCommands();
    }

    public ArrayList<Command.LabelTokenCommand> getLabelTokenCommands() {
        return this.commandSet.getLabelTokenCommands();
    }

    public ArrayList<Command.PropertyKeyTokenCommand> getPropertyKeyTokenCommands() {
        return this.commandSet.getPropertyKeyTokenCommands();
    }

    public RecordChanges<Long, NodeRecord, Void> getNodeRecords() {
        return this.recordChangeSet.getNodeRecords();
    }

    public RecordChanges<Long, RelationshipRecord, Void> getRelRecords() {
        return this.recordChangeSet.getRelRecords();
    }

    public RecordChanges<Long, Collection<DynamicRecord>, SchemaRule> getSchemaRuleChanges() {
        return this.recordChangeSet.getSchemaRuleChanges();
    }

    public RecordChanges<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.recordChangeSet.getPropertyRecords();
    }

    public RecordChanges<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.recordChangeSet.getRelGroupRecords();
    }

    public RecordChanges<Integer, PropertyKeyTokenRecord, Void> getPropertyKeyTokenRecords() {
        return this.recordChangeSet.getPropertyKeyTokenChanges();
    }

    public RecordChanges<Integer, LabelTokenRecord, Void> getLabelTokenRecords() {
        return this.recordChangeSet.getLabelTokenChanges();
    }

    public RecordChanges<Integer, RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenRecords() {
        return this.recordChangeSet.getRelationshipTypeTokenChanges();
    }

    public void generateNeoStoreCommand(NeoStoreRecord neoStoreRecord) {
        this.commandSet.generateNeoStoreCommand(neoStoreRecord);
    }

    public Command.NeoStoreCommand getNeoStoreCommand() {
        return this.commandSet.getNeoStoreCommand();
    }

    public ArrayList<Command.RelationshipGroupCommand> getRelGroupCommands() {
        return this.commandSet.getRelGroupCommands();
    }

    public void setNeoStoreCommand(Command.NeoStoreCommand xaCommand) {
        this.commandSet.getNeoStoreCommand().init(xaCommand.getRecord());
    }

    public RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> getRelationshipGroup(NodeRecord node, int type) {
        long groupId = node.getNextRel();
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        HashSet<Integer> allTypes = new HashSet<Integer>();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordAccess.RecordProxy change = ((RecordChanges)this.recordChangeSet.getRelGroupRecords()).getOrLoad((Object)groupId, (Object)type);
            RelationshipGroupRecord record = (RelationshipGroupRecord)change.forReadingData();
            record.setPrev(previousGroupId);
            allTypes.add(record.getType());
            if (record.getType() == type) {
                return change;
            }
            previousGroupId = groupId;
            groupId = record.getNext();
        }
        return null;
    }

    public TransactionState getTransactionState() {
        return this.txState;
    }
}

