/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdateNodeIdComparator;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.DenseNodeChainPosition;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.SingleChainPosition;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.TokenRecord;
import org.neo4j.kernel.impl.nioneo.store.TokenStore;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.nioneo.xa.IntegrityValidator;
import org.neo4j.kernel.impl.nioneo.xa.LazyIndexUpdates;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccess;
import org.neo4j.kernel.impl.nioneo.xa.RecordChanges;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.NeoXaCommandExecutor;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class NeoStoreTransaction
extends XaTransaction {
    private final Map<Long, Map<Integer, RelationshipGroupRecord>> relGroupCache = new HashMap<Long, Map<Integer, RelationshipGroupRecord>>();
    private RecordChanges<Long, NeoStoreRecord, Void> neoStoreRecord;
    private boolean committed = false;
    private boolean prepared = false;
    private final long lastCommittedTxWhenTransactionStarted;
    private final CacheAccessBackDoor cacheAccess;
    private final IndexingService indexes;
    private final NeoStore neoStore;
    private final LabelScanStore labelScanStore;
    private final IntegrityValidator integrityValidator;
    private final KernelTransactionImplementation kernelTransaction;
    private final LockService locks;
    private final NeoStoreTransactionContext context;
    private final NeoXaCommandExecutor executor;
    private static final CacheRemover PROPERTY_KEY_CACHE_REMOVER = new CacheRemover(){

        @Override
        public void remove(CacheAccessBackDoor cacheAccess, int id) {
            cacheAccess.removePropertyKeyFromCache(id);
        }
    };
    private static final CacheRemover RELATIONSHIP_TYPE_CACHE_REMOVER = new CacheRemover(){

        @Override
        public void remove(CacheAccessBackDoor cacheAccess, int id) {
            cacheAccess.removeRelationshipTypeFromCache(id);
        }
    };
    private static final CacheRemover LABEL_CACHE_REMOVER = new CacheRemover(){

        @Override
        public void remove(CacheAccessBackDoor cacheAccess, int id) {
            cacheAccess.removeLabelFromCache(id);
        }
    };

    NeoStoreTransaction(long lastCommittedTxWhenTransactionStarted, XaLogicalLog log, NeoStore neoStore, CacheAccessBackDoor cacheAccess, IndexingService indexingService, LabelScanStore labelScanStore, IntegrityValidator integrityValidator, KernelTransactionImplementation kernelTransaction, LockService locks, NeoStoreTransactionContext context) {
        super(log, context.getTransactionState());
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.neoStore = neoStore;
        this.executor = new NeoXaCommandExecutor(neoStore, indexingService);
        this.cacheAccess = cacheAccess;
        this.indexes = indexingService;
        this.labelScanStore = labelScanStore;
        this.integrityValidator = integrityValidator;
        this.kernelTransaction = kernelTransaction;
        this.locks = locks;
        this.context = context;
    }

    public KernelTransactionImplementation kernelTransaction() {
        return this.kernelTransaction;
    }

    @Override
    public boolean isReadOnly() {
        if (this.isRecovered()) {
            return this.context.getNodeCommands().isEmpty() && this.context.getPropCommands().isEmpty() && this.context.getRelCommands().isEmpty() && this.context.getSchemaRuleCommands().isEmpty() && this.context.getRelationshipTypeTokenCommands().isEmpty() && this.context.getLabelTokenCommands().isEmpty() && this.context.getRelGroupCommands().isEmpty() && this.context.getPropertyKeyTokenCommands().isEmpty() && this.kernelTransaction.isReadOnly();
        }
        return this.context.getNodeRecords().changeSize() == 0 && this.context.getRelRecords().changeSize() == 0 && this.context.getSchemaRuleChanges().changeSize() == 0 && this.context.getPropertyRecords().changeSize() == 0 && this.context.getRelGroupRecords().changeSize() == 0 && this.context.getPropertyKeyTokenRecords().changeSize() == 0 && this.context.getLabelTokenRecords().changeSize() == 0 && this.context.getRelationshipTypeTokenRecords().changeSize() == 0 && this.kernelTransaction.isReadOnly();
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
    }

    @Override
    public void doAddCommand(XaCommand command) {
    }

    @Override
    protected void doPrepare() throws XAException {
        Command command;
        if (this.committed) {
            throw new XAException("Cannot prepare committed transaction[" + this.getIdentifier() + "]");
        }
        if (this.prepared) {
            throw new XAException("Cannot prepare prepared transaction[" + this.getIdentifier() + "]");
        }
        this.prepared = true;
        int noOfCommands = this.context.getNodeRecords().changeSize() + this.context.getRelRecords().changeSize() + this.context.getPropertyRecords().changeSize() + this.context.getSchemaRuleChanges().changeSize() + this.context.getPropertyKeyTokenRecords().changeSize() + this.context.getLabelTokenRecords().changeSize() + this.context.getRelationshipTypeTokenRecords().changeSize() + this.context.getRelGroupRecords().changeSize();
        ArrayList<Command> commands = new ArrayList<Command>(noOfCommands);
        for (RecordAccess.RecordProxy recordProxy : this.context.getLabelTokenRecords().changes()) {
            command = new Command.LabelTokenCommand();
            ((Command.LabelTokenCommand)command).init((LabelTokenRecord)recordProxy.forReadingLinkage());
            this.context.getLabelTokenCommands().add((Command.LabelTokenCommand)command);
            commands.add(command);
        }
        for (RecordAccess.RecordProxy recordProxy : this.context.getRelationshipTypeTokenRecords().changes()) {
            command = new Command.RelationshipTypeTokenCommand();
            ((Command.RelationshipTypeTokenCommand)command).init((RelationshipTypeTokenRecord)recordProxy.forReadingLinkage());
            this.context.getRelationshipTypeTokenCommands().add((Command.RelationshipTypeTokenCommand)command);
            commands.add(command);
        }
        for (RecordChanges.RecordChange<Number, AbstractBaseRecord, Void> recordChange : this.context.getNodeRecords().changes()) {
            NodeRecord record = (NodeRecord)recordChange.forReadingLinkage();
            this.integrityValidator.validateNodeRecord(record);
            Command.NodeCommand command2 = new Command.NodeCommand();
            command2.init((NodeRecord)recordChange.getBefore(), record);
            this.context.getNodeCommands().put(record.getId(), command2);
            commands.add(command2);
        }
        if (this.context.getUpgradedDenseNodes() != null) {
            for (NodeRecord nodeRecord : this.context.getUpgradedDenseNodes()) {
                this.removeNodeFromCache(nodeRecord.getId());
            }
        }
        for (RecordAccess.RecordProxy recordProxy : this.context.getRelRecords().changes()) {
            command = new Command.RelationshipCommand();
            ((Command.RelationshipCommand)command).init((RelationshipRecord)recordProxy.forReadingLinkage());
            this.context.getRelCommands().add((Command.RelationshipCommand)command);
            commands.add(command);
        }
        if (this.neoStoreRecord != null) {
            for (RecordAccess.RecordProxy recordProxy : this.neoStoreRecord.changes()) {
                this.context.generateNeoStoreCommand((NeoStoreRecord)recordProxy.forReadingData());
                this.addCommand(this.context.getNeoStoreCommand());
            }
        }
        for (RecordAccess.RecordProxy recordProxy : this.context.getPropertyKeyTokenRecords().changes()) {
            command = new Command.PropertyKeyTokenCommand();
            ((Command.PropertyKeyTokenCommand)command).init((PropertyKeyTokenRecord)recordProxy.forReadingLinkage());
            this.context.getPropertyKeyTokenCommands().add((Command.PropertyKeyTokenCommand)command);
            commands.add(command);
        }
        for (RecordChanges.RecordChange recordChange : this.context.getPropertyRecords().changes()) {
            command = new Command.PropertyCommand();
            ((Command.PropertyCommand)command).init((PropertyRecord)recordChange.getBefore(), (PropertyRecord)recordChange.forReadingLinkage());
            this.context.getPropCommands().add((Command.PropertyCommand)command);
            commands.add(command);
        }
        for (RecordChanges.RecordChange recordChange : this.context.getSchemaRuleChanges().changes()) {
            this.integrityValidator.validateSchemaRule((SchemaRule)recordChange.getAdditionalData());
            command = new Command.SchemaRuleCommand();
            ((Command.SchemaRuleCommand)command).init((Collection)recordChange.getBefore(), (Collection)recordChange.forChangingData(), (SchemaRule)recordChange.getAdditionalData(), -1L);
            this.context.getSchemaRuleCommands().add((Command.SchemaRuleCommand)command);
            commands.add(command);
        }
        for (RecordAccess.RecordProxy recordProxy : this.context.getRelGroupRecords().changes()) {
            command = new Command.RelationshipGroupCommand();
            ((Command.RelationshipGroupCommand)command).init((RelationshipGroupRecord)recordProxy.forReadingData());
            this.context.getRelGroupCommands().add((Command.RelationshipGroupCommand)command);
            commands.add(command);
        }
        assert (commands.size() == noOfCommands) : "Expected " + noOfCommands + " final commands, got " + commands.size() + " instead";
        this.intercept(commands);
        for (Command command2 : commands) {
            this.addCommand(command2);
        }
        this.integrityValidator.validateTransactionStartKnowledge(this.lastCommittedTxWhenTransactionStarted);
    }

    protected void intercept(List<Command> commands) {
    }

    @Override
    protected void injectCommand(XaCommand xaCommand) {
        if (xaCommand instanceof Command.NodeCommand) {
            Command.NodeCommand nodeCommand = (Command.NodeCommand)xaCommand;
            this.context.getNodeCommands().put(nodeCommand.getKey(), nodeCommand);
        } else if (xaCommand instanceof Command.RelationshipCommand) {
            this.context.getRelCommands().add((Command.RelationshipCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyCommand) {
            this.context.getPropCommands().add((Command.PropertyCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyKeyTokenCommand) {
            this.context.getPropertyKeyTokenCommands().add((Command.PropertyKeyTokenCommand)xaCommand);
        } else if (xaCommand instanceof Command.RelationshipTypeTokenCommand) {
            this.context.getRelationshipTypeTokenCommands().add((Command.RelationshipTypeTokenCommand)xaCommand);
        } else if (xaCommand instanceof Command.LabelTokenCommand) {
            this.context.getLabelTokenCommands().add((Command.LabelTokenCommand)xaCommand);
        } else if (xaCommand instanceof Command.NeoStoreCommand) {
            assert (this.context.getNeoStoreCommand().getRecord() == null);
            this.context.setNeoStoreCommand((Command.NeoStoreCommand)xaCommand);
        } else if (xaCommand instanceof Command.SchemaRuleCommand) {
            this.context.getSchemaRuleCommands().add((Command.SchemaRuleCommand)xaCommand);
        } else if (xaCommand instanceof Command.RelationshipGroupCommand) {
            this.context.getRelGroupCommands().add((Command.RelationshipGroupCommand)xaCommand);
        } else {
            throw new IllegalArgumentException("Unknown command " + xaCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRollback() throws XAException {
        if (this.committed) {
            throw new XAException("Cannot rollback partialy commited transaction[" + this.getIdentifier() + "]. Recover and " + "commit");
        }
        try {
            boolean freeIds = this.neoStore.freeIdsDuringRollback();
            for (RecordAccess.RecordProxy recordProxy : this.context.getNodeRecords().changes()) {
                NodeRecord record = (NodeRecord)recordProxy.forReadingLinkage();
                if (freeIds && record.isCreated()) {
                    this.getNodeStore().freeId(record.getId());
                }
                this.removeNodeFromCache(record.getId());
            }
            for (RecordChanges.RecordChange<Long, PrimitiveRecord, Void> recordChange : this.context.getRelRecords().changes()) {
                long id = recordChange.getKey();
                RelationshipRecord record = (RelationshipRecord)recordChange.forReadingLinkage();
                if (freeIds && recordChange.isCreated()) {
                    this.getRelationshipStore().freeId(id);
                }
                this.removeRelationshipFromCache(id);
            }
            if (this.neoStoreRecord != null) {
                this.removeGraphPropertiesFromCache();
            }
            this.rollbackTokenRecordChanges(this.context.getPropertyKeyTokenRecords(), this.getPropertyKeyTokenStore(), freeIds, PROPERTY_KEY_CACHE_REMOVER);
            this.rollbackTokenRecordChanges(this.context.getLabelTokenRecords(), this.getLabelTokenStore(), freeIds, LABEL_CACHE_REMOVER);
            this.rollbackTokenRecordChanges(this.context.getRelationshipTypeTokenRecords(), this.getRelationshipTypeStore(), freeIds, RELATIONSHIP_TYPE_CACHE_REMOVER);
            for (RecordAccess.RecordProxy recordProxy : this.context.getPropertyRecords().changes()) {
                PropertyRecord record = (PropertyRecord)recordProxy.forReadingLinkage();
                if (record.getNodeId() != -1L) {
                    this.removeNodeFromCache(record.getNodeId());
                } else if (record.getRelId() != -1L) {
                    this.removeRelationshipFromCache(record.getRelId());
                }
                if (!record.isCreated()) continue;
                if (freeIds) {
                    this.getPropertyStore().freeId(record.getId());
                }
                for (PropertyBlock block : record.getPropertyBlocks()) {
                    for (DynamicRecord dynamicRecord : block.getValueRecords()) {
                        if (!dynamicRecord.isCreated()) continue;
                        if (dynamicRecord.getType() == PropertyType.STRING.intValue()) {
                            this.getPropertyStore().freeStringBlockId(dynamicRecord.getId());
                            continue;
                        }
                        if (dynamicRecord.getType() == PropertyType.ARRAY.intValue()) {
                            this.getPropertyStore().freeArrayBlockId(dynamicRecord.getId());
                            continue;
                        }
                        throw new InvalidRecordException("Unknown type on " + dynamicRecord);
                    }
                }
            }
            for (RecordAccess.RecordProxy recordProxy : this.context.getSchemaRuleChanges().changes()) {
                long id = -1L;
                for (DynamicRecord record : (Collection)recordProxy.forChangingData()) {
                    if (id == -1L) {
                        id = record.getId();
                    }
                    if (!freeIds || !record.isCreated()) continue;
                    this.getSchemaStore().freeId(record.getId());
                }
            }
            for (RecordAccess.RecordProxy recordProxy : this.context.getRelGroupRecords().changes()) {
                RelationshipGroupRecord record = (RelationshipGroupRecord)recordProxy.forReadingData();
                if (!freeIds || !record.isCreated()) continue;
                this.getRelationshipGroupStore().freeId(record.getId());
            }
        }
        finally {
            this.clear();
        }
    }

    private <T extends TokenRecord> void rollbackTokenRecordChanges(RecordChanges<Integer, T, Void> records, TokenStore<T> store, boolean freeIds, CacheRemover cacheRemover) {
        for (RecordChanges.RecordChange<Integer, T, Void> record : records.changes()) {
            if (record.isCreated()) {
                if (freeIds) {
                    store.freeId(record.getKey());
                }
                for (DynamicRecord dynamicRecord : ((TokenRecord)record.forReadingLinkage()).getNameRecords()) {
                    if (!dynamicRecord.isCreated()) continue;
                    store.getNameStore().freeId((int)dynamicRecord.getId());
                }
            }
            cacheRemover.remove(this.cacheAccess, record.getKey());
        }
    }

    private void removeRelationshipFromCache(long id) {
        this.cacheAccess.removeRelationshipFromCache(id);
    }

    private void removeNodeFromCache(long id) {
        this.cacheAccess.removeNodeFromCache(id);
    }

    private void removeGraphPropertiesFromCache() {
        this.cacheAccess.removeGraphPropertiesFromCache();
    }

    private void addRelationshipType(int id) {
        this.setRecovered();
        Token type = this.isRecovered() ? this.neoStore.getRelationshipTypeStore().getToken(id, true) : this.neoStore.getRelationshipTypeStore().getToken(id);
        this.cacheAccess.addRelationshipTypeToken(type);
    }

    private void addLabel(int id) {
        Token labelId = this.isRecovered() ? this.neoStore.getLabelTokenStore().getToken(id, true) : this.neoStore.getLabelTokenStore().getToken(id);
        this.cacheAccess.addLabelToken(labelId);
    }

    private void addPropertyKey(int id) {
        Token index = this.isRecovered() ? this.neoStore.getPropertyKeyTokenStore().getToken(id, true) : this.neoStore.getPropertyKeyTokenStore().getToken(id);
        this.cacheAccess.addPropertyKeyToken(index);
    }

    @Override
    public void doCommit() throws XAException {
        if (!this.isRecovered() && !this.prepared) {
            throw new XAException("Cannot commit non prepared transaction[" + this.getIdentifier() + "]");
        }
        if (this.isRecovered()) {
            boolean wasInRecovery = this.neoStore.isInRecoveryMode();
            this.neoStore.setRecoveredStatus(true);
            try {
                this.applyCommit(true);
                return;
            }
            catch (IOException e) {
                throw Exceptions.withCause(new XAException(), e);
            }
            finally {
                this.neoStore.setRecoveredStatus(wasInRecovery);
            }
        }
        if (this.getCommitTxId() != this.neoStore.getLastCommittedTx() + 1L) {
            throw new RuntimeException("Tx id: " + this.getCommitTxId() + " not next transaction (" + this.neoStore.getLastCommittedTx() + ")");
        }
        try {
            this.applyCommit(false);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException(), e);
        }
    }

    private void applyCommit(boolean isRecovered) throws IOException {
        try (LockGroup lockGroup = new LockGroup();){
            this.committed = true;
            CommandSorter sorter = new CommandSorter();
            if (this.context.getRelationshipTypeTokenCommands().size() != 0) {
                Collections.sort(this.context.getRelationshipTypeTokenCommands(), sorter);
                for (Command.RelationshipTypeTokenCommand relationshipTypeTokenCommand : this.context.getRelationshipTypeTokenCommands()) {
                    this.executor.execute(relationshipTypeTokenCommand);
                    if (!isRecovered) continue;
                    this.addRelationshipType((int)relationshipTypeTokenCommand.getKey());
                }
            }
            if (this.context.getLabelTokenCommands().size() != 0) {
                Collections.sort(this.context.getLabelTokenCommands(), sorter);
                for (Command.LabelTokenCommand labelTokenCommand : this.context.getLabelTokenCommands()) {
                    this.executor.execute(labelTokenCommand);
                    if (!isRecovered) continue;
                    this.addLabel((int)labelTokenCommand.getKey());
                }
            }
            if (this.context.getPropertyKeyTokenCommands().size() != 0) {
                Collections.sort(this.context.getPropertyKeyTokenCommands(), sorter);
                for (Command.PropertyKeyTokenCommand propertyKeyTokenCommand : this.context.getPropertyKeyTokenCommands()) {
                    this.executor.execute(propertyKeyTokenCommand);
                    if (!isRecovered) continue;
                    this.addPropertyKey((int)propertyKeyTokenCommand.getKey());
                }
            }
            Collections.sort(this.context.getRelCommands(), sorter);
            Collections.sort(this.context.getPropCommands(), sorter);
            this.executeCreated(lockGroup, isRecovered, this.context.getPropCommands(), this.context.getRelCommands(), this.context.getNodeCommands().values(), this.context.getRelGroupCommands());
            this.executeModified(lockGroup, isRecovered, this.context.getPropCommands(), this.context.getRelCommands(), this.context.getNodeCommands().values(), this.context.getRelGroupCommands());
            this.executeDeleted(lockGroup, this.context.getPropCommands(), this.context.getRelCommands(), this.context.getNodeCommands().values(), this.context.getRelGroupCommands());
            Collection<NodeLabelUpdate> labelUpdates = this.gatherLabelUpdatesSortedByNodeId();
            if (!labelUpdates.isEmpty()) {
                this.updateLabelScanStore(labelUpdates);
                this.cacheAccess.applyLabelUpdates(labelUpdates);
            }
            if (!this.context.getNodeCommands().isEmpty() || !this.context.getPropCommands().isEmpty()) {
                this.indexes.updateIndexes(new LazyIndexUpdates(this.getNodeStore(), this.getPropertyStore(), this.groupedNodePropertyCommands(this.context.getPropCommands()), new HashMap<Long, Command.NodeCommand>(this.context.getNodeCommands())));
            }
            block15: for (Command.SchemaRuleCommand command : this.context.getSchemaRuleCommands()) {
                command.setTxId(this.getCommitTxId());
                this.executor.execute(command);
                switch (command.getMode()) {
                    case DELETE: {
                        this.cacheAccess.removeSchemaRuleFromCache(command.getKey());
                        continue block15;
                    }
                }
                this.cacheAccess.addSchemaRule(command.getSchemaRule());
            }
            if (this.context.getNeoStoreCommand().getRecord() != null) {
                this.executor.execute(this.context.getNeoStoreCommand());
                if (isRecovered) {
                    this.removeGraphPropertiesFromCache();
                }
            }
            if (!isRecovered) {
                this.context.updateFirstRelationships();
                this.context.commitCows();
            }
            this.neoStore.setLastCommittedTx(this.getCommitTxId());
            if (isRecovered) {
                this.neoStore.updateIdGenerators();
            }
        }
    }

    private Collection<List<Command.PropertyCommand>> groupedNodePropertyCommands(Iterable<Command.PropertyCommand> propCommands) {
        HashMap<Long, ArrayList<Command.PropertyCommand>> groups = new HashMap<Long, ArrayList<Command.PropertyCommand>>();
        for (Command.PropertyCommand command : propCommands) {
            PropertyRecord record = command.getAfter();
            if (!record.isNodeSet()) continue;
            long nodeId = command.getAfter().getNodeId();
            ArrayList<Command.PropertyCommand> group = (ArrayList<Command.PropertyCommand>)groups.get(nodeId);
            if (group == null) {
                group = new ArrayList<Command.PropertyCommand>();
                groups.put(nodeId, group);
            }
            group.add(command);
        }
        return groups.values();
    }

    private Collection<NodeLabelUpdate> gatherLabelUpdatesSortedByNodeId() {
        ArrayList<NodeLabelUpdate> labelUpdates = new ArrayList<NodeLabelUpdate>();
        for (Command.NodeCommand nodeCommand : this.context.getNodeCommands().values()) {
            NodeLabels labelFieldBefore = NodeLabelsField.parseLabelsField(nodeCommand.getBefore());
            NodeLabels labelFieldAfter = NodeLabelsField.parseLabelsField(nodeCommand.getAfter());
            if (labelFieldBefore.isInlined() && labelFieldAfter.isInlined() && nodeCommand.getBefore().getLabelField() == nodeCommand.getAfter().getLabelField()) continue;
            long[] labelsBefore = labelFieldBefore.getIfLoaded();
            long[] labelsAfter = labelFieldAfter.getIfLoaded();
            if (labelsBefore == null || labelsAfter == null) continue;
            labelUpdates.add(NodeLabelUpdate.labelChanges(nodeCommand.getKey(), labelsBefore, labelsAfter));
        }
        Collections.sort(labelUpdates, new NodeLabelUpdateNodeIdComparator());
        return labelUpdates;
    }

    private void updateLabelScanStore(Iterable<NodeLabelUpdate> labelUpdates) {
        try (LabelScanWriter writer = this.labelScanStore.newWriter();){
            for (NodeLabelUpdate update : labelUpdates) {
                writer.write(update);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.context.relationshipCreate(id, typeId, startNodeId, endNodeId);
    }

    public ArrayMap<Integer, DefinedProperty> relDelete(long relId) {
        return this.context.relationshipDelete(relId);
    }

    @SafeVarargs
    private final void executeCreated(LockGroup lockGroup, boolean removeFromCache, Collection<? extends Command> ... commands) throws IOException {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.CREATE) continue;
                this.lockEntity(lockGroup, command);
                this.executor.execute(command);
                if (!removeFromCache) continue;
                command.applyToCache(this.cacheAccess);
            }
        }
    }

    @SafeVarargs
    private final void executeModified(LockGroup lockGroup, boolean removeFromCache, Collection<? extends Command> ... commands) throws IOException {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.UPDATE) continue;
                this.lockEntity(lockGroup, command);
                this.executor.execute(command);
                if (!removeFromCache) continue;
                command.applyToCache(this.cacheAccess);
            }
        }
    }

    @SafeVarargs
    private final void executeDeleted(LockGroup lockGroup, Collection<? extends Command> ... commands) throws IOException {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != Command.Mode.DELETE) continue;
                this.lockEntity(lockGroup, command);
                this.executor.execute(command);
                command.applyToCache(this.cacheAccess);
            }
        }
    }

    private void lockEntity(LockGroup lockGroup, Command command) {
        long nodeId;
        if (command instanceof Command.NodeCommand) {
            lockGroup.add(this.locks.acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK));
        }
        if (command instanceof Command.PropertyCommand && (nodeId = ((Command.PropertyCommand)command).getNodeId()) != -1L) {
            lockGroup.add(this.locks.acquireNodeLock(nodeId, LockService.LockType.WRITE_LOCK));
        }
    }

    private void clear() {
        this.context.close();
        this.relGroupCache.clear();
        this.neoStoreRecord = null;
    }

    private RelationshipTypeTokenStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    private LabelTokenStore getLabelTokenStore() {
        return this.neoStore.getLabelTokenStore();
    }

    private PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.neoStore.getPropertyKeyTokenStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private SchemaStore getSchemaStore() {
        return this.neoStore.getSchemaStore();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private RelationshipGroupStore getRelationshipGroupStore() {
        return this.neoStore.getRelationshipGroupStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    public NodeRecord nodeLoadLight(long nodeId) {
        try {
            return (NodeRecord)((RecordChanges.RecordChange)this.context.getNodeRecords().getOrLoad((Object)nodeId, null)).forReadingLinkage();
        }
        catch (InvalidRecordException e) {
            return null;
        }
    }

    public RelationshipRecord relLoadLight(long id) {
        try {
            return (RelationshipRecord)((RecordChanges.RecordChange)this.context.getRelRecords().getOrLoad((Object)id, null)).forReadingLinkage();
        }
        catch (InvalidRecordException e) {
            return null;
        }
    }

    public ArrayMap<Integer, DefinedProperty> nodeDelete(long nodeId) {
        NodeRecord nodeRecord = (NodeRecord)((RecordChanges.RecordChange)this.context.getNodeRecords().getOrLoad((Object)nodeId, null)).forChangingData();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        nodeRecord.setInUse(false);
        nodeRecord.setLabelField(0L, Collections.emptyList());
        return this.getAndDeletePropertyChain(nodeRecord);
    }

    private ArrayMap<Integer, DefinedProperty> getAndDeletePropertyChain(NodeRecord nodeRecord) {
        return this.context.getAndDeletePropertyChain(nodeRecord);
    }

    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, RelationshipLoadingPosition> getMoreRelationships(long nodeId, RelationshipLoadingPosition position, RelIdArray.DirectionWrapper direction, int[] types) {
        return NeoStoreTransaction.getMoreRelationships(nodeId, position, this.getRelGrabSize(), direction, types, this.getRelationshipStore());
    }

    public void relRemoveProperty(long relId, int propertyKey) {
        RecordAccess.RecordProxy rel = this.context.getRelRecords().getOrLoad((Object)relId, null);
        RelationshipRecord relRecord = (RelationshipRecord)rel.forReadingLinkage();
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property remove on relationship[" + relId + "] illegal since it has been deleted.");
        }
        this.context.removeProperty(rel, propertyKey);
    }

    public void relLoadProperties(long relId, boolean light, PropertyReceiver receiver) {
        RelationshipRecord relRecord;
        RecordChanges.RecordChange<Long, RelationshipRecord, Void> rel = this.context.getRelRecords().getIfLoaded(relId);
        if (rel != null) {
            if (rel.isCreated()) {
                return;
            }
            if (!rel.forReadingLinkage().inUse() && !light) {
                throw new IllegalStateException("Relationship[" + relId + "] has been deleted in this tx");
            }
        }
        if (!(relRecord = this.getRelationshipStore().getRecord(relId)).inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        NeoStoreTransaction.loadProperties(this.getPropertyStore(), relRecord.getNextProp(), receiver);
    }

    public void nodeLoadProperties(long nodeId, boolean light, PropertyReceiver receiver) {
        NodeRecord nodeRecord;
        RecordChanges.RecordChange<Long, NodeRecord, Void> node = this.context.getNodeRecords().getIfLoaded(nodeId);
        if (node != null) {
            if (node.isCreated()) {
                return;
            }
            if (!node.forReadingLinkage().inUse() && !light) {
                throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
            }
        }
        if (!(nodeRecord = this.getNodeStore().getRecord(nodeId)).inUse()) {
            throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
        }
        NeoStoreTransaction.loadProperties(this.getPropertyStore(), nodeRecord.getNextProp(), receiver);
    }

    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        RecordAccess.RecordProxy node = this.context.getNodeRecords().getOrLoad((Object)nodeId, null);
        NodeRecord nodeRecord = (NodeRecord)node.forReadingLinkage();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property remove on node[" + nodeId + "] illegal since it has been deleted.");
        }
        this.context.removeProperty(node, propertyKey);
    }

    public DefinedProperty relChangeProperty(long relId, int propertyKey, Object value) {
        RecordAccess.RecordProxy rel = this.context.getRelRecords().getOrLoad((Object)relId, null);
        if (!((RelationshipRecord)rel.forReadingLinkage()).inUse()) {
            throw new IllegalStateException("Property change on relationship[" + relId + "] illegal since it has been deleted.");
        }
        this.context.primitiveChangeProperty(rel, propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public DefinedProperty nodeChangeProperty(long nodeId, int propertyKey, Object value) {
        RecordAccess.RecordProxy node = this.context.getNodeRecords().getOrLoad((Object)nodeId, null);
        if (!((NodeRecord)node.forReadingLinkage()).inUse()) {
            throw new IllegalStateException("Property change on node[" + nodeId + "] illegal since it has been deleted.");
        }
        this.context.primitiveChangeProperty(node, propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public DefinedProperty relAddProperty(long relId, int propertyKey, Object value) {
        RecordAccess.RecordProxy rel = this.context.getRelRecords().getOrLoad((Object)relId, null);
        RelationshipRecord relRecord = (RelationshipRecord)rel.forReadingLinkage();
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property add on relationship[" + relId + "] illegal since it has been deleted.");
        }
        this.context.primitiveAddProperty(rel, propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public DefinedProperty nodeAddProperty(long nodeId, int propertyKey, Object value) {
        RecordAccess.RecordProxy node = this.context.getNodeRecords().getOrLoad((Object)nodeId, null);
        NodeRecord nodeRecord = (NodeRecord)node.forReadingLinkage();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property add on node[" + nodeId + "] illegal since it has been deleted.");
        }
        this.context.primitiveAddProperty(node, propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = this.context.getNodeRecords().create(nodeId, null).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
    }

    public void createPropertyKeyToken(String key, int id) {
        this.context.createPropertyKeyToken(key, id);
    }

    public void createLabelToken(String name, int id) {
        this.context.createLabelToken(name, id);
    }

    public void createRelationshipTypeToken(int id, String name) {
        this.context.createRelationshipTypeToken(name, id);
    }

    private RecordAccess.RecordProxy<Long, NeoStoreRecord, Void> getOrLoadNeoStoreRecord() {
        if (this.neoStoreRecord == null) {
            this.neoStoreRecord = new RecordChanges<Long, NeoStoreRecord, Void>(new RecordAccess.Loader<Long, NeoStoreRecord, Void>(){

                @Override
                public NeoStoreRecord newUnused(Long key, Void additionalData) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public NeoStoreRecord load(Long key, Void additionalData) {
                    return NeoStoreTransaction.this.neoStore.asRecord();
                }

                @Override
                public void ensureHeavy(NeoStoreRecord record) {
                }

                @Override
                public NeoStoreRecord clone(NeoStoreRecord neoStoreRecord) {
                    throw new UnsupportedOperationException("Clone on NeoStoreRecord");
                }
            }, false);
        }
        return this.neoStoreRecord.getOrLoad((Object)0L, null);
    }

    public DefinedProperty graphAddProperty(int propertyKey, Object value) {
        this.context.primitiveAddProperty(this.getOrLoadNeoStoreRecord(), propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public DefinedProperty graphChangeProperty(int propertyKey, Object value) {
        this.context.primitiveChangeProperty(this.getOrLoadNeoStoreRecord(), propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public void graphRemoveProperty(int propertyKey) {
        RecordAccess.RecordProxy<Long, NeoStoreRecord, Void> recordChange = this.getOrLoadNeoStoreRecord();
        this.context.removeProperty(recordChange, propertyKey);
    }

    public void graphLoadProperties(boolean light, PropertyReceiver records) {
        NeoStoreTransaction.loadProperties(this.getPropertyStore(), this.neoStore.asRecord().getNextProp(), records);
    }

    public void createSchemaRule(SchemaRule schemaRule) {
        for (DynamicRecord change : this.context.getSchemaRuleChanges().create(schemaRule.getId(), schemaRule).forChangingData()) {
            change.setInUse(true);
            change.setCreated();
        }
    }

    public void dropSchemaRule(SchemaRule rule) {
        RecordAccess.RecordProxy change = this.context.getSchemaRuleChanges().getOrLoad((Object)rule.getId(), (Object)rule);
        Collection records = (Collection)change.forChangingData();
        for (DynamicRecord record : records) {
            record.setInUse(false);
        }
    }

    public void addLabelToNode(int labelId, long nodeId) {
        NodeRecord nodeRecord = (NodeRecord)((RecordChanges.RecordChange)this.context.getNodeRecords().getOrLoad((Object)nodeId, null)).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).add(labelId, this.getNodeStore(), this.getNodeStore().getDynamicLabelStore());
    }

    public void removeLabelFromNode(int labelId, long nodeId) {
        NodeRecord nodeRecord = (NodeRecord)((RecordChanges.RecordChange)this.context.getNodeRecords().getOrLoad((Object)nodeId, null)).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).remove(labelId, this.getNodeStore());
    }

    public PrimitiveLongIterator getLabelsForNode(long nodeId) {
        NodeRecord node = this.getNodeStore().getRecord(nodeId);
        return PrimitiveLongCollections.iterator((long[])NodeLabelsField.parseLabelsField(node).get(this.getNodeStore()));
    }

    public void setConstraintIndexOwner(IndexRule indexRule, long constraintId) {
        RecordAccess.RecordProxy change = this.context.getSchemaRuleChanges().getOrLoad((Object)indexRule.getId(), (Object)indexRule);
        Collection records = (Collection)change.forChangingData();
        indexRule = indexRule.withOwningConstraint(constraintId);
        records.clear();
        records.addAll(this.getSchemaStore().allocateFrom(indexRule));
    }

    private static Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, RelationshipLoadingPosition> getMoreRelationships(long nodeId, RelationshipLoadingPosition originalPosition, int grabSize, RelIdArray.DirectionWrapper direction, int[] types, RelationshipStore relStore) {
        ArrayList<RelationshipRecord> out = new ArrayList<RelationshipRecord>();
        ArrayList<RelationshipRecord> in = new ArrayList<RelationshipRecord>();
        ArrayList<RelationshipRecord> loop = null;
        EnumMap result = new EnumMap(RelIdArray.DirectionWrapper.class);
        result.put(RelIdArray.DirectionWrapper.OUTGOING, out);
        result.put(RelIdArray.DirectionWrapper.INCOMING, in);
        RelationshipLoadingPosition loadPosition = originalPosition.clone();
        long position = loadPosition.position(direction, types);
        for (int i = 0; i < grabSize && position != (long)Record.NO_NEXT_RELATIONSHIP.intValue(); ++i) {
            RelationshipRecord relRecord = relStore.getChainRecord(position);
            if (relRecord == null) {
                return Pair.of(result, loadPosition);
            }
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (relRecord.inUse()) {
                if (firstNode == secondNode) {
                    if (loop == null) {
                        loop = new ArrayList<RelationshipRecord>();
                        result.put(RelIdArray.DirectionWrapper.BOTH, loop);
                    }
                    loop.add(relRecord);
                } else if (firstNode == nodeId) {
                    out.add(relRecord);
                } else if (secondNode == nodeId) {
                    in.add(relRecord);
                }
            } else {
                --i;
            }
            long next = 0L;
            if (firstNode == nodeId) {
                next = relRecord.getFirstNextRel();
            } else if (secondNode == nodeId) {
                next = relRecord.getSecondNextRel();
            } else {
                throw new InvalidRecordException("While loading relationships for Node[" + nodeId + "] a Relationship[" + relRecord.getId() + "] was encountered that had startNode: " + firstNode + " and endNode: " + secondNode + ", i.e. which had neither start nor end node as the node we're " + "loading relationships for");
            }
            position = loadPosition.nextPosition(next, direction, types);
        }
        return Pair.of(result, loadPosition);
    }

    private static void loadPropertyChain(Collection<PropertyRecord> chain, PropertyStore propertyStore, PropertyReceiver receiver) {
        if (chain != null) {
            for (PropertyRecord propRecord : chain) {
                for (PropertyBlock propBlock : propRecord.getPropertyBlocks()) {
                    receiver.receive(propBlock.newPropertyData(propertyStore), propRecord.getId());
                }
            }
        }
    }

    static void loadProperties(PropertyStore propertyStore, long nextProp, PropertyReceiver receiver) {
        Collection<PropertyRecord> chain = propertyStore.getPropertyRecordChain(nextProp);
        if (chain != null) {
            NeoStoreTransaction.loadPropertyChain(chain, propertyStore, receiver);
        }
    }

    static Map<Integer, RelationshipGroupRecord> loadRelationshipGroups(long firstGroup, RelationshipGroupStore store) {
        long groupId = firstGroup;
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        HashMap<Integer, RelationshipGroupRecord> result = new HashMap<Integer, RelationshipGroupRecord>();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord record = store.getRecord(groupId);
            record.setPrev(previousGroupId);
            result.put(record.getType(), record);
            previousGroupId = groupId;
            groupId = record.getNext();
        }
        return result;
    }

    private Map<Integer, RelationshipGroupRecord> loadRelationshipGroups(NodeRecord node) {
        assert (node.isDense());
        return NeoStoreTransaction.loadRelationshipGroups(node.getNextRel(), this.getRelationshipGroupStore());
    }

    public int getRelationshipCount(long id, int type, RelIdArray.DirectionWrapper direction) {
        NodeRecord node = this.getNodeStore().getRecord(id);
        long nextRel = node.getNextRel();
        if (nextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return 0;
        }
        if (!node.isDense()) {
            assert (type == -1);
            assert (direction == RelIdArray.DirectionWrapper.BOTH);
            return this.getRelationshipCount(node, nextRel);
        }
        Map<Integer, RelationshipGroupRecord> groups = this.loadRelationshipGroups(node);
        if (type == -1 && direction == RelIdArray.DirectionWrapper.BOTH) {
            int count = 0;
            for (RelationshipGroupRecord group : groups.values()) {
                count += this.getRelationshipCount(node, group.getFirstOut());
                count += this.getRelationshipCount(node, group.getFirstIn());
                count += this.getRelationshipCount(node, group.getFirstLoop());
            }
            return count;
        }
        if (type == -1) {
            int count = 0;
            for (RelationshipGroupRecord group : groups.values()) {
                count += this.getRelationshipCount(node, group, direction);
            }
            return count;
        }
        if (direction == RelIdArray.DirectionWrapper.BOTH) {
            RelationshipGroupRecord group = groups.get(type);
            if (group == null) {
                return 0;
            }
            int count = 0;
            count += this.getRelationshipCount(node, group.getFirstOut());
            count += this.getRelationshipCount(node, group.getFirstIn());
            return count += this.getRelationshipCount(node, group.getFirstLoop());
        }
        RelationshipGroupRecord group = groups.get(type);
        if (group == null) {
            return 0;
        }
        return this.getRelationshipCount(node, group, direction);
    }

    private int getRelationshipCount(NodeRecord node, RelationshipGroupRecord group, RelIdArray.DirectionWrapper direction) {
        if (direction == RelIdArray.DirectionWrapper.BOTH) {
            return this.getRelationshipCount(node, RelIdArray.DirectionWrapper.OUTGOING.getNextRel(group)) + this.getRelationshipCount(node, RelIdArray.DirectionWrapper.INCOMING.getNextRel(group)) + this.getRelationshipCount(node, RelIdArray.DirectionWrapper.BOTH.getNextRel(group));
        }
        return this.getRelationshipCount(node, direction.getNextRel(group)) + this.getRelationshipCount(node, RelIdArray.DirectionWrapper.BOTH.getNextRel(group));
    }

    private int getRelationshipCount(NodeRecord node, long relId) {
        if (relId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return 0;
        }
        RelationshipRecord rel = this.getRelationshipStore().getRecord(relId);
        return (int)(node.getId() == rel.getFirstNode() ? rel.getFirstPrevRel() : rel.getSecondPrevRel());
    }

    public Integer[] getRelationshipTypes(long id) {
        Map<Integer, RelationshipGroupRecord> groups = this.loadRelationshipGroups(this.getNodeStore().getRecord(id));
        Integer[] types = new Integer[groups.size()];
        int i = 0;
        for (Integer type : groups.keySet()) {
            types[i++] = type;
        }
        return types;
    }

    public RelationshipLoadingPosition getRelationshipChainPosition(long id) {
        RecordChanges.RecordChange<Long, NodeRecord, Void> nodeChange = this.context.getNodeRecords().getIfLoaded(id);
        if (nodeChange != null && nodeChange.isCreated()) {
            return RelationshipLoadingPosition.EMPTY;
        }
        NodeRecord node = this.getNodeStore().getRecord(id);
        if (node.isDense()) {
            long firstGroup = node.getNextRel();
            if (firstGroup == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                return RelationshipLoadingPosition.EMPTY;
            }
            Map<Integer, RelationshipGroupRecord> groups = NeoStoreTransaction.loadRelationshipGroups(firstGroup, this.neoStore.getRelationshipGroupStore());
            return new DenseNodeChainPosition(groups);
        }
        long firstRel = node.getNextRel();
        return firstRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? RelationshipLoadingPosition.EMPTY : new SingleChainPosition(firstRel);
    }

    public static interface PropertyReceiver {
        public void receive(DefinedProperty var1, long var2);
    }

    static class CommandSorter
    implements Comparator<Command>,
    Serializable {
        CommandSorter() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id2;
            long id1 = o1.getKey();
            long diff = id1 - (id2 = o2.getKey());
            if (diff > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)diff;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CommandSorter;
        }

        public int hashCode() {
            return 3217;
        }
    }

    static class LabelChangeSummary {
        private static final long[] NO_LABELS = new long[0];
        private final long[] addedLabels;
        private final long[] removedLabels;

        LabelChangeSummary(long[] labelsBefore, long[] labelsAfter) {
            long[] addedLabels = new long[labelsAfter.length];
            long[] removedLabels = new long[labelsBefore.length];
            int addedLabelsCursor = 0;
            int removedLabelsCursor = 0;
            for (long labelAfter : labelsAfter) {
                if (Arrays.binarySearch(labelsBefore, labelAfter) >= 0) continue;
                addedLabels[addedLabelsCursor++] = labelAfter;
            }
            for (long labelBefore : labelsBefore) {
                if (Arrays.binarySearch(labelsAfter, labelBefore) >= 0) continue;
                removedLabels[removedLabelsCursor++] = labelBefore;
            }
            this.addedLabels = this.shrink(addedLabels, addedLabelsCursor);
            this.removedLabels = this.shrink(removedLabels, removedLabelsCursor);
        }

        private long[] shrink(long[] array, int toLength) {
            if (toLength == 0) {
                return NO_LABELS;
            }
            return array.length == toLength ? array : Arrays.copyOf(array, toLength);
        }

        public boolean hasAddedLabels() {
            return this.addedLabels.length > 0;
        }

        public boolean hasRemovedLabels() {
            return this.removedLabels.length > 0;
        }

        public long[] getAddedLabels() {
            return this.addedLabels;
        }

        public long[] getRemovedLabels() {
            return this.removedLabels;
        }
    }

    private static interface CacheRemover {
        public void remove(CacheAccessBackDoor var1, int var2);
    }
}

