/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.NoSuchElementException;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

public class StoreIdIterator
implements PrimitiveLongIterator {
    private final RecordStore<?> store;
    private long highId;
    private long id;

    public StoreIdIterator(RecordStore<?> store) {
        this.store = store;
        this.id = store.getNumberOfReservedLowIds();
    }

    public String toString() {
        return String.format("%s[id=%s/%s; store=%s]", this.getClass().getSimpleName(), this.id, this.highId, this.store);
    }

    public boolean hasNext() {
        if (this.id < this.highId) {
            return true;
        }
        this.highId = this.store.getHighId();
        return this.id < this.highId;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(String.format("ID [%s] has exceeded the high ID [%s] of %s.", this.id, this.highId, this.store));
        }
        return this.id++;
    }
}

