/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.OverlappingFileLockException;
import java.util.LinkedList;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdSequence;
import org.neo4j.kernel.impl.nioneo.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.ReadOnlyIdGenerator;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class CommonAbstractStore
implements IdSequence,
AutoCloseable {
    public static final String ALL_STORES_VERSION = "v0.A.3";
    public static final String UNKNOWN_VERSION = "Unknown";
    protected Config configuration;
    private final IdGeneratorFactory idGeneratorFactory;
    private final WindowPoolFactory windowPoolFactory;
    protected FileSystemAbstraction fileSystemAbstraction;
    protected final File storageFileName;
    protected final IdType idType;
    protected StringLogger stringLogger;
    private IdGenerator idGenerator = null;
    private StoreChannel fileChannel = null;
    private WindowPool windowPool;
    private boolean storeOk = true;
    private Throwable causeOfStoreNotOk;
    private FileLock fileLock;
    private boolean readOnly = false;
    private boolean backupSlave = false;
    private long highestUpdateRecordId = -1L;
    private final StoreVersionMismatchHandler versionMismatchHandler;
    private boolean isRecovered = false;

    public CommonAbstractStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, StoreVersionMismatchHandler versionMismatchHandler) {
        this.storageFileName = fileName;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.windowPoolFactory = windowPoolFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.idType = idType;
        this.stringLogger = stringLogger;
        this.versionMismatchHandler = versionMismatchHandler;
        try {
            this.checkStorage();
            this.checkVersion();
            this.loadStorage();
        }
        catch (Exception e) {
            this.releaseFileLockAndCloseFileChannel();
            throw Exceptions.launderedException(e);
        }
    }

    public String getTypeAndVersionDescriptor() {
        return CommonAbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor());
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return CommonAbstractStore.buildTypeDescriptorAndVersion(typeDescriptor, ALL_STORES_VERSION);
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor, String version) {
        return typeDescriptor + " " + version;
    }

    protected long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    public abstract String getTypeDescriptor();

    protected void checkStorage() {
        this.readOnly = this.configuration.get(Configuration.read_only);
        this.backupSlave = this.configuration.get(Configuration.backup_slave);
        if (!this.fileSystemAbstraction.fileExists(this.storageFileName)) {
            throw new StoreNotFoundException("No such store[" + this.storageFileName + "] in " + this.fileSystemAbstraction);
        }
        try {
            this.fileChannel = this.fileSystemAbstraction.open(this.storageFileName, this.readOnly ? "r" : "rw");
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open file " + this.storageFileName, e);
        }
        try {
            if (!this.readOnly || this.backupSlave) {
                this.fileLock = this.fileSystemAbstraction.tryLock(this.storageFileName, this.fileChannel);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to lock store[" + this.storageFileName + "]", e);
        }
        catch (OverlappingFileLockException e) {
            throw new IllegalStateException("Unable to lock store [" + this.storageFileName + "], this is usually caused by another Neo4j kernel already running in " + "this JVM for this particular store");
        }
    }

    protected void checkVersion() {
        try {
            this.verifyCorrectTypeDescriptorAndVersion();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to check version " + this.getStorageFileName(), e);
        }
    }

    protected void loadStorage() {
        try {
            this.readAndVerifyBlockSize();
            this.verifyFileSizeAndTruncate();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load storage " + this.getStorageFileName(), e);
        }
        this.loadIdGenerator();
        this.windowPool = this.windowPoolFactory.create(this.getStorageFileName(), this.getEffectiveRecordSize(), this.getFileChannel(), this.configuration, this.stringLogger, this.getNumberOfReservedLowIds());
    }

    protected abstract int getEffectiveRecordSize();

    protected abstract void verifyFileSizeAndTruncate() throws IOException;

    protected abstract void readAndVerifyBlockSize() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIdGenerator() {
        try {
            if (!this.isReadOnly() || this.isBackupSlave()) {
                this.openIdGenerator();
            } else {
                this.openReadOnlyIdGenerator(this.getEffectiveRecordSize());
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk(e);
        }
        finally {
            if (!this.getStoreOk() && this.stringLogger != null) {
                this.stringLogger.logMessage(this.getStorageFileName() + " non clean shutdown detected", true);
            }
        }
    }

    protected void verifyCorrectTypeDescriptorAndVersion() throws IOException {
        String expectedTypeDescriptorAndVersion = this.getTypeAndVersionDescriptor();
        int length = UTF8.encode(expectedTypeDescriptorAndVersion).length;
        byte[] bytes = new byte[length];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long fileSize = this.getFileChannel().size();
        if (fileSize >= (long)length) {
            this.getFileChannel().position(fileSize - (long)length);
        } else if (!this.isReadOnly()) {
            this.setStoreNotOk(new IllegalStateException("Invalid file size " + fileSize + " for " + this + ". Expected " + length + " or bigger"));
            return;
        }
        this.getFileChannel().read(buffer);
        String foundTypeDescriptorAndVersion = UTF8.decode(bytes);
        if (!expectedTypeDescriptorAndVersion.equals(foundTypeDescriptorAndVersion) && !this.isReadOnly()) {
            if (foundTypeDescriptorAndVersion.startsWith(this.getTypeDescriptor())) {
                this.versionMismatchHandler.mismatch(ALL_STORES_VERSION, foundTypeDescriptorAndVersion);
            } else {
                this.setStoreNotOk(new IllegalStateException("Unexpected version " + foundTypeDescriptorAndVersion + ", expected " + expectedTypeDescriptorAndVersion));
            }
        }
    }

    protected void rebuildIdGenerator() {
        if (this.isReadOnly() && !this.isBackupSlave()) {
            throw new ReadOnlyDbException();
        }
        this.stringLogger.debug("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        File idFile = new File(this.getStorageFileName().getPath() + ".id");
        if (this.fileSystemAbstraction.fileExists(idFile)) {
            boolean success = this.fileSystemAbstraction.deleteFile(idFile);
            assert (success) : "Couldn't delete " + idFile.getPath() + ", still open?";
        }
        this.createIdGenerator(idFile);
        this.openIdGenerator();
        this.setHighId(this.getNumberOfReservedLowIds());
        StoreChannel fileChannel = this.getFileChannel();
        boolean fastRebuild = this.doFastIdGeneratorRebuild();
        long defraggedCount = 0L;
        try {
            long fileSize = fileChannel.size();
            int recordSize = this.getRecordSize();
            if (fastRebuild) {
                this.setHighId(this.findHighIdBackwards());
            } else {
                defraggedCount = this.fullScanIdRebuild(fileChannel, fileSize, recordSize, this.reserveIdsDuringRebuild());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.stringLogger.logMessage(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount, true);
        this.stringLogger.debug("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        if (!fastRebuild) {
            this.closeIdGenerator();
            this.openIdGenerator();
        }
    }

    protected boolean reserveIdsDuringRebuild() {
        return false;
    }

    private long fullScanIdRebuild(StoreChannel fileChannel, long fileSize, int recordSize, boolean justReserveIds) throws IOException {
        long defraggedCount = 0L;
        ByteBuffer byteBuffer = ByteBuffer.allocate(recordSize);
        LinkedList<Long> freeIdList = new LinkedList<Long>();
        long i = this.getNumberOfReservedLowIds();
        while (i * (long)recordSize < fileSize) {
            fileChannel.position(i * (long)recordSize);
            byteBuffer.clear();
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            if (!this.isRecordInUse(byteBuffer)) {
                if (justReserveIds) {
                    byteBuffer.clear();
                    byteBuffer.put(Record.IN_USE.byteValue()).putInt(Record.RESERVED.intValue());
                    byteBuffer.flip();
                    fileChannel.write(byteBuffer, i * (long)recordSize);
                    byteBuffer.clear();
                } else {
                    freeIdList.add(i);
                }
            } else {
                this.setHighId(i + 1L);
                while (!freeIdList.isEmpty()) {
                    this.freeId((Long)freeIdList.removeFirst());
                    ++defraggedCount;
                }
            }
            ++i;
        }
        return defraggedCount;
    }

    protected boolean doFastIdGeneratorRebuild() {
        return this.configuration.get(Configuration.rebuild_idgenerators_fast);
    }

    protected void closeStorage() {
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isBackupSlave() {
        return this.backupSlave;
    }

    protected void setStoreNotOk(Throwable cause) {
        if (this.readOnly && !this.isBackupSlave()) {
            throw new UnderlyingStorageException("Cannot start up on non clean store as read only");
        }
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
    }

    protected boolean getStoreOk() {
        return this.storeOk;
    }

    @Override
    public long nextId() {
        return this.idGenerator.nextId();
    }

    public void freeId(long id) {
        this.idGenerator.freeId(id);
    }

    public long getHighId() {
        long updateHighId = this.highestUpdateRecordId;
        long genHighId = this.idGenerator != null ? this.idGenerator.getHighId() : -1L;
        if (updateHighId > genHighId) {
            return updateHighId;
        }
        return genHighId;
    }

    public void setHighId(long highId) {
        if (this.idGenerator != null) {
            this.idGenerator.setHighId(highId);
        }
    }

    public void makeStoreOk() {
        if (!this.storeOk) {
            if (this.readOnly && !this.backupSlave) {
                throw new ReadOnlyDbException();
            }
            this.rebuildIdGenerator();
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
    }

    public void rebuildIdGenerators() {
        if (this.readOnly && !this.backupSlave) {
            throw new ReadOnlyDbException();
        }
        this.rebuildIdGenerator();
    }

    protected File getStoreDir() {
        return this.configuration.get(Configuration.store_dir);
    }

    protected PersistenceWindow acquireWindow(long position, OperationType type) {
        if (!(this.isInRecoveryMode() || position <= this.getHighId() && this.storeOk)) {
            throw new InvalidRecordException("Position[" + position + "] requested for high id[" + this.getHighId() + "], store is ok[" + this.storeOk + "] recovery[" + this.isInRecoveryMode() + "]", this.causeOfStoreNotOk);
        }
        return this.windowPool.acquire(position, type);
    }

    protected void releaseWindow(PersistenceWindow window) {
        this.windowPool.release(window);
    }

    public void flushAll() {
        this.windowPool.flushAll();
    }

    public boolean isInRecoveryMode() {
        return this.isRecovered;
    }

    protected void setRecovered() {
        this.isRecovered = true;
    }

    protected void unsetRecovered() {
        this.isRecovered = false;
    }

    public File getStorageFileName() {
        return this.storageFileName;
    }

    protected void openIdGenerator() {
        this.idGenerator = this.openIdGenerator(new File(this.storageFileName.getPath() + ".id"), this.idType.getGrabSize());
        this.updateHighId();
    }

    protected IdGenerator openIdGenerator(File fileName, int grabSize) {
        return this.idGeneratorFactory.open(this.fileSystemAbstraction, fileName, grabSize, this.getIdType(), this.findHighIdBackwards());
    }

    protected long findHighIdBackwards() {
        try {
            StoreChannel fileChannel = this.getFileChannel();
            int recordSize = this.getRecordSize();
            long fileSize = fileChannel.size();
            long highId = fileSize / (long)recordSize;
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.bytesRequiredToDetermineInUse());
            for (long i = highId; i >= 0L; --i) {
                fileChannel.position(i * (long)recordSize);
                if (fileChannel.read(byteBuffer) <= 0) continue;
                byteBuffer.flip();
                boolean isInUse = this.isRecordInUse(byteBuffer);
                byteBuffer.clear();
                if (!isInUse) continue;
                return i + 1L;
            }
            return this.getNumberOfReservedLowIds();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
    }

    public abstract int getRecordSize();

    protected abstract boolean isRecordInUse(ByteBuffer var1);

    protected int bytesRequiredToDetermineInUse() {
        return 1;
    }

    protected void createIdGenerator(File fileName) {
        this.idGeneratorFactory.create(this.fileSystemAbstraction, fileName, 0L);
    }

    protected void openReadOnlyIdGenerator(int recordSize) {
        try {
            this.idGenerator = new ReadOnlyIdGenerator(this.storageFileName + ".id", this.fileChannel.size() / (long)recordSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    protected void closeIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.close();
        }
    }

    @Override
    public void close() {
        if (this.fileChannel == null) {
            return;
        }
        this.closeStorage();
        if (this.windowPool != null) {
            this.windowPool.close();
            this.windowPool = null;
        }
        if (this.isReadOnly() && !this.isBackupSlave() || this.idGenerator == null || !this.storeOk) {
            this.releaseFileLockAndCloseFileChannel();
            return;
        }
        final long highId = this.idGenerator.getHighId();
        final int recordSize = this.getEffectiveRecordSize();
        this.idGenerator.close();
        IOException storedIoe = null;
        if (!this.readOnly || this.backupSlave) {
            try {
                FileUtils.windowsSafeIOOperation(new FileUtils.FileOperation(){

                    @Override
                    public void perform() throws IOException {
                        CommonAbstractStore.this.fileChannel.position(highId * (long)recordSize);
                        ByteBuffer buffer = ByteBuffer.wrap(UTF8.encode(CommonAbstractStore.this.getTypeAndVersionDescriptor()));
                        CommonAbstractStore.this.fileChannel.write(buffer);
                        CommonAbstractStore.this.stringLogger.debug("Closing " + CommonAbstractStore.this.storageFileName + ", truncating at " + CommonAbstractStore.this.fileChannel.position() + " vs file size " + CommonAbstractStore.this.fileChannel.size());
                        CommonAbstractStore.this.fileChannel.truncate(CommonAbstractStore.this.fileChannel.position());
                        CommonAbstractStore.this.fileChannel.force(false);
                        CommonAbstractStore.this.releaseFileLockAndCloseFileChannel();
                    }
                });
            }
            catch (IOException e) {
                storedIoe = e;
            }
        } else {
            this.releaseFileLockAndCloseFileChannel();
        }
        if (storedIoe != null) {
            throw new UnderlyingStorageException("Unable to close store " + this.getStorageFileName(), storedIoe);
        }
    }

    protected void releaseFileLockAndCloseFileChannel() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (IOException e) {
            this.stringLogger.warn("Could not close [" + this.storageFileName + "]", e);
        }
        this.fileChannel = null;
    }

    protected final StoreChannel getFileChannel() {
        return this.fileChannel;
    }

    public long getHighestPossibleIdInUse() {
        if (this.idGenerator != null) {
            return this.idGenerator.getHighId() - 1L;
        }
        return this.calculateHighestIdInUseByLookingAtFileSize();
    }

    private long calculateHighestIdInUseByLookingAtFileSize() {
        try {
            return this.getFileChannel().size() / (long)this.getRecordSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getNumberOfIdsInUse() {
        return this.idGenerator.getNumberOfIdsInUse();
    }

    public int getNumberOfReservedLowIds() {
        return 0;
    }

    public WindowPoolStats getWindowPoolStats() {
        return this.windowPool.getStats();
    }

    public IdType getIdType() {
        return this.idType;
    }

    protected void registerIdFromUpdateRecord(long id) {
        if (this.isInRecoveryMode()) {
            this.highestUpdateRecordId = Math.max(this.highestUpdateRecordId, id + 1L);
        }
    }

    protected void updateHighId() {
        long highId = this.highestUpdateRecordId;
        this.highestUpdateRecordId = -1L;
        if (highId > this.getHighId()) {
            this.setHighId(highId);
        }
    }

    public void logVersions(StringLogger.LineLogger logger) {
        logger.logLine("  " + this.getTypeAndVersionDescriptor());
    }

    public void logIdUsage(StringLogger.LineLogger lineLogger) {
        lineLogger.logLine(String.format("  %s: used=%s high=%s", this.getTypeDescriptor(), this.getNumberOfIdsInUse(), this.getHighestPossibleIdInUse()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static abstract class Configuration {
        public static final Setting<File> store_dir = InternalAbstractGraphDatabase.Configuration.store_dir;
        public static final Setting<File> neo_store = InternalAbstractGraphDatabase.Configuration.neo_store;
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<Boolean> backup_slave = GraphDatabaseSettings.backup_slave;
        public static final Setting<Boolean> use_memory_mapped_buffers = GraphDatabaseSettings.use_memory_mapped_buffers;
        public static final Setting<Boolean> rebuild_idgenerators_fast = GraphDatabaseSettings.rebuild_idgenerators_fast;
    }
}

