/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ThreadToStatementContextBridge
extends LifecycleAdapter
implements Provider<Statement> {
    private final PersistenceManager persistenceManager;
    private boolean isShutdown;

    public ThreadToStatementContextBridge(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
        this.isShutdown = false;
    }

    public boolean hasTransaction() {
        this.checkIfShutdown();
        return this.persistenceManager.hasCurrentTransaction();
    }

    @Override
    public Statement instance() {
        this.checkIfShutdown();
        KernelTransaction transaction = this.persistenceManager.currentKernelTransactionForReading();
        if (null == transaction) {
            throw new NotInTransactionException();
        }
        return transaction.acquireStatement();
    }

    public void assertInTransaction() {
        this.checkIfShutdown();
        this.persistenceManager.getCurrentTransaction();
    }

    @Override
    public void shutdown() throws Throwable {
        this.isShutdown = true;
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }
}

