/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.event.PropertyEntry;

class PropertyEntryImpl<T extends PropertyContainer>
implements PropertyEntry<T> {
    private final T entity;
    private final String key;
    private final Object value;
    private final Object valueBeforeTransaction;

    private PropertyEntryImpl(T entity, String key, Object value, Object valueBeforeTransaction) {
        this.entity = entity;
        this.key = key;
        this.value = value;
        this.valueBeforeTransaction = valueBeforeTransaction;
    }

    static <T extends PropertyContainer> PropertyEntry<T> assigned(T entity, String key, Object value, Object valueBeforeTransaction) {
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        return new PropertyEntryImpl<T>(entity, key, value, valueBeforeTransaction);
    }

    static <T extends PropertyContainer> PropertyEntry<T> removed(T entity, String key, Object valueBeforeTransaction) {
        return new PropertyEntryImpl<T>(entity, key, null, valueBeforeTransaction);
    }

    @Override
    public T entity() {
        return this.entity;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object previouslyCommitedValue() {
        return this.valueBeforeTransaction;
    }

    @Override
    public Object value() {
        if (this.value == null) {
            throw new IllegalStateException("PropertyEntry[" + this.entity + ", " + this.key + "] has no value, it represents a removed property");
        }
        return this.value;
    }

    public String toString() {
        return "PropertyEntry[entity:" + this.entity + ", key:" + this.key + ", value:" + this.value + ", valueBeforeTx:" + this.valueBeforeTransaction + "]";
    }
}

