/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.IntegralNumberProperty;

abstract class FloatingPointNumberProperty
extends DefinedProperty {
    FloatingPointNumberProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    abstract double doubleValue();

    @Override
    final int valueHash() {
        long value = (long)this.doubleValue();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public final boolean valueEquals(Object other) {
        if (other instanceof Number) {
            Number that = (Number)other;
            if (other instanceof Double || other instanceof Float) {
                return this.doubleValue() == that.doubleValue();
            }
            return FloatingPointNumberProperty.numbersEqual(this.doubleValue(), that.longValue());
        }
        return false;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty other) {
        if (other instanceof FloatingPointNumberProperty) {
            FloatingPointNumberProperty that = (FloatingPointNumberProperty)other;
            return this.doubleValue() == that.doubleValue();
        }
        if (other instanceof IntegralNumberProperty) {
            IntegralNumberProperty that = (IntegralNumberProperty)other;
            return FloatingPointNumberProperty.numbersEqual(this.doubleValue(), that.longValue());
        }
        return false;
    }
}

