/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public interface Visitor<E, FAILURE extends Exception> {
    public boolean visit(E var1) throws FAILURE;

    public static final class SafeGenerics {
        public static <T, F extends Exception> Visitor<? super T, ? extends F> castOrNull(Class<T> eType, Class<F> fType, Object visitor) {
            if (visitor instanceof Visitor) {
                for (Type iface : visitor.getClass().getGenericInterfaces()) {
                    ParameterizedType paramType;
                    if (!(iface instanceof ParameterizedType) || (paramType = (ParameterizedType)iface).getRawType() != Visitor.class) continue;
                    Type arg = paramType.getActualTypeArguments()[0];
                    if (arg instanceof ParameterizedType) {
                        arg = ((ParameterizedType)arg).getRawType();
                    }
                    if (!(arg instanceof Class) || !((Class)arg).isAssignableFrom(eType)) continue;
                    return (Visitor)visitor;
                }
            }
            return null;
        }

        private SafeGenerics() {
        }
    }
}

