/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.neo4j.helpers.Function;

public final class UTF8 {
    public static final Function<String, byte[]> encode = new Function<String, byte[]>(){

        @Override
        public byte[] apply(String s) {
            return UTF8.encode(s);
        }
    };
    public static final Function<byte[], String> decode = new Function<byte[], String>(){

        @Override
        public String apply(byte[] bytes) {
            return UTF8.decode(bytes);
        }
    };

    public static byte[] encode(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw UTF8.cantBelieveUtf8IsntAvailableInThisJvmError(e);
        }
    }

    public static String decode(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw UTF8.cantBelieveUtf8IsntAvailableInThisJvmError(e);
        }
    }

    public static String decode(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw UTF8.cantBelieveUtf8IsntAvailableInThisJvmError(e);
        }
    }

    public static String getDecodedStringFrom(ByteBuffer source) {
        int count = source.getInt();
        byte[] data = new byte[count];
        source.get(data);
        return UTF8.decode(data);
    }

    public static void putEncodedStringInto(String text, ByteBuffer target) {
        byte[] data = UTF8.encode(text);
        target.putInt(data.length);
        target.put(data);
    }

    public static int computeRequiredByteBufferSize(String text) {
        return UTF8.encode(text).length + 4;
    }

    private static Error cantBelieveUtf8IsntAvailableInThisJvmError(UnsupportedEncodingException e) {
        return new Error("UTF-8 should be available on all JVMs", e);
    }

    private UTF8() {
    }
}

