/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.logging.Logging;

public class GraphDatabaseFactoryState {
    private List<Class<?>> settingsClasses;
    private List<KernelExtensionFactory<?>> kernelExtensions;
    private List<CacheProvider> cacheProviders;
    private List<TransactionInterceptorProvider> txInterceptorProviders;
    private Logging logging;

    public GraphDatabaseFactoryState() {
        this.settingsClasses = new ArrayList();
        this.settingsClasses.add(GraphDatabaseSettings.class);
        this.kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            this.kernelExtensions.add(factory);
        }
        this.cacheProviders = Iterables.toList(Service.load(CacheProvider.class));
        this.txInterceptorProviders = Iterables.toList(Service.load(TransactionInterceptorProvider.class));
    }

    public GraphDatabaseFactoryState(GraphDatabaseFactoryState previous) {
        this.settingsClasses = new ArrayList(previous.settingsClasses);
        this.kernelExtensions = new ArrayList(previous.kernelExtensions);
        this.cacheProviders = new ArrayList<CacheProvider>(previous.cacheProviders);
        this.txInterceptorProviders = new ArrayList<TransactionInterceptorProvider>(previous.txInterceptorProviders);
        this.logging = previous.logging;
    }

    public Iterable<KernelExtensionFactory<?>> getKernelExtension() {
        return this.kernelExtensions;
    }

    public void setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.kernelExtensions.clear();
        this.addKernelExtensions(newKernelExtensions);
    }

    public void addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        for (KernelExtensionFactory<?> newKernelExtension : newKernelExtensions) {
            this.kernelExtensions.add(newKernelExtension);
        }
    }

    public List<CacheProvider> getCacheProviders() {
        return this.cacheProviders;
    }

    public void setCacheProviders(Iterable<CacheProvider> newCacheProviders) {
        this.cacheProviders.clear();
        for (CacheProvider newCacheProvider : newCacheProviders) {
            this.cacheProviders.add(newCacheProvider);
        }
    }

    public List<TransactionInterceptorProvider> getTransactionInterceptorProviders() {
        return this.txInterceptorProviders;
    }

    public void setTransactionInterceptorProviders(Iterable<TransactionInterceptorProvider> transactionInterceptorProviders) {
        this.txInterceptorProviders.clear();
        for (TransactionInterceptorProvider newTxInterceptorProvider : transactionInterceptorProviders) {
            this.txInterceptorProviders.add(newTxInterceptorProvider);
        }
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    public InternalAbstractGraphDatabase.Dependencies databaseDependencies() {
        return new GraphDatabaseDependencies(this.logging, this.settingsClasses, this.kernelExtensions, this.cacheProviders, this.txInterceptorProviders);
    }
}

