/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.Transaction;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.logging.Logging;

public class TransactionStateFactory {
    protected LockManager lockManager;
    protected NodeManager nodeManager;
    protected final Logging logging;
    protected RemoteTxHook txHook;
    protected TxIdGenerator txIdGenerator;

    public TransactionStateFactory(Logging logging) {
        this.logging = logging;
    }

    public void setDependencies(LockManager lockManager, NodeManager nodeManager, RemoteTxHook txHook, TxIdGenerator txIdGenerator) {
        this.lockManager = lockManager;
        this.nodeManager = nodeManager;
        this.txHook = txHook;
        this.txIdGenerator = txIdGenerator;
    }

    public TransactionState create(Transaction tx) {
        return new WritableTransactionState(this.lockManager, this.nodeManager, this.logging, tx, this.txHook, this.txIdGenerator);
    }

    public static TransactionStateFactory noStateFactory(Logging logging) {
        return new TransactionStateFactory(logging){

            @Override
            public TransactionState create(Transaction tx) {
                return TransactionState.NO_STATE;
            }
        };
    }
}

