/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class UpgradableDatabase {
    private final StoreVersionCheck storeVersionCheck;

    public UpgradableDatabase(StoreVersionCheck storeVersionCheck) {
        this.storeVersionCheck = storeVersionCheck;
    }

    public boolean storeFilesUpgradeable(File neoStoreFile) {
        try {
            this.checkUpgradeable(neoStoreFile);
            return true;
        }
        catch (StoreUpgrader.UnableToUpgradeException e) {
            return false;
        }
    }

    public void checkUpgradeable(File neoStoreFile) {
        File storeDirectory = neoStoreFile.getParentFile();
        for (StoreFile store : StoreFile.legacyStoreFiles()) {
            String expectedVersion = store.legacyVersion();
            File storeFile = new File(storeDirectory, store.storeFileName());
            Pair<StoreVersionCheck.Outcome, String> outcome = this.storeVersionCheck.hasVersion(storeFile, expectedVersion);
            if (outcome.first().isSuccessful()) continue;
            switch (outcome.first()) {
                case missingStoreFile: {
                    throw new StoreUpgrader.UpgradeMissingStoreFilesException(storeFile.getName());
                }
                case storeVersionNotFound: {
                    throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(storeFile.getName());
                }
                case unexpectedUpgradingStoreVersion: {
                    throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(storeFile.getName(), expectedVersion, outcome.other());
                }
            }
            throw new IllegalArgumentException(outcome.first().name());
        }
    }
}

