/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.coreapi.schema.BaseConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class PropertyUniqueConstraintCreator
extends BaseConstraintCreator {
    protected final String propertyKey;

    PropertyUniqueConstraintCreator(InternalSchemaActions internalCreator, Label label, String propertyKeyOrNull) {
        super(internalCreator, label);
        this.propertyKey = propertyKeyOrNull;
    }

    @Override
    public final ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one unique constraint at a time.");
    }

    @Override
    public final ConstraintDefinition create() {
        this.assertInTransaction();
        try {
            return this.actions.createPropertyUniquenessConstraint(this.label, this.propertyKey);
        }
        catch (KernelException e) {
            String userMessage = this.actions.getUserMessage(e);
            throw new ConstraintViolationException(userMessage, e);
        }
    }
}

