/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.Token;

public class NonTransactionalTokenNameLookup
implements TokenNameLookup {
    private final LabelTokenHolder labelTokenHolder;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;

    public NonTransactionalTokenNameLookup(LabelTokenHolder labelTokenHolder, PropertyKeyTokenHolder propertyKeyTokenHolder) {
        this.labelTokenHolder = labelTokenHolder;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
    }

    @Override
    public String labelGetName(int labelId) {
        try {
            Object token = this.labelTokenHolder.getTokenByIdOrNull(labelId);
            if (token != null) {
                return ((Token)token).name();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return String.format("label[%d]", labelId);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) {
        try {
            Object token = this.propertyKeyTokenHolder.getTokenByIdOrNull(propertyKeyId);
            if (token != null) {
                return ((Token)token).name();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return String.format("property[%d]", propertyKeyId);
    }
}

