/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.Random;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.test.Randoms;
import org.neo4j.tooling.Distribution;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.csv.Deserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;

class SimpleDataGeneratorBatch<T> {
    private final Header header;
    private final Random random;
    private final Randoms randoms;
    private final long nodeCount;
    private final long start;
    private final Distribution<String> labels;
    private final Distribution<String> relationshipTypes;
    private final Deserialization<T> deserialization;
    private final T[] target;
    private long cursor;
    private long position;

    SimpleDataGeneratorBatch(Header header, long start, long randomSeed, long nodeCount, Distribution<String> labels, Distribution<String> relationshipTypes, Deserialization<T> deserialization, T[] target) {
        this.header = header;
        this.start = start;
        this.nodeCount = nodeCount;
        this.labels = labels;
        this.relationshipTypes = relationshipTypes;
        this.target = target;
        this.random = new Random(randomSeed);
        this.randoms = new Randoms(this.random, Randoms.DEFAULT);
        this.deserialization = deserialization;
        deserialization.initialize();
    }

    T[] get() {
        for (int i = 0; i < this.target.length; ++i) {
            this.target[i] = this.next();
        }
        return this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T next() {
        block10: for (Header.Entry entry : this.header.entries()) {
            switch (entry.type()) {
                case ID: {
                    this.deserialization.handle(entry, this.idValue(entry, this.start + this.cursor));
                    continue block10;
                }
                case PROPERTY: {
                    this.deserialization.handle(entry, this.randomProperty(entry, this.random));
                    continue block10;
                }
                case LABEL: {
                    this.deserialization.handle(entry, (Object)this.randomLabels(this.random));
                    continue block10;
                }
                case START_ID: 
                case END_ID: {
                    this.deserialization.handle(entry, this.idValue(entry, Math.abs(this.random.nextLong()) % this.nodeCount));
                    continue block10;
                }
                case TYPE: {
                    this.deserialization.handle(entry, (Object)this.randomRelationshipType(this.random));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException(entry.toString());
                }
            }
        }
        try {
            Object object = this.deserialization.materialize();
            return (T)object;
        }
        finally {
            this.deserialization.clear();
            ++this.cursor;
        }
    }

    private Object idValue(Header.Entry entry, long id) {
        switch (entry.extractor().toString()) {
            case "String": {
                return "" + id;
            }
            case "long": {
                return id;
            }
        }
        throw new IllegalArgumentException(entry.toString());
    }

    private String randomRelationshipType(Random random) {
        this.position += 6L;
        return this.relationshipTypes.random(random);
    }

    private Object randomProperty(Header.Entry entry, Random random) {
        String type = entry.extractor().toString();
        if (type.equals("String")) {
            return this.randoms.string(5, 20, 3);
        }
        if (type.equals("long")) {
            this.position += 8L;
            return random.nextInt(Integer.MAX_VALUE);
        }
        if (type.equals("int")) {
            this.position += 4L;
            return random.nextInt(20);
        }
        throw new IllegalArgumentException("" + entry);
    }

    private String[] randomLabels(Random random) {
        int length = random.nextInt(3);
        if (length == 0) {
            return InputEntity.NO_LABELS;
        }
        Object[] result = new String[length];
        int i = 0;
        while (i < result.length) {
            String candidate = this.labels.random(random);
            if (ArrayUtil.contains((Object[])result, (int)i, (Object)candidate)) continue;
            result[i++] = candidate;
        }
        this.position += (long)(length * 6);
        return result;
    }
}

