/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.neo4j.backup.BackupClient;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class LogicalLogSeeder {
    private final StringLogger logger;

    public LogicalLogSeeder(StringLogger logger) {
        this.logger = logger;
    }

    public void ensureAtLeastOneLogicalLogPresent(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb) {
        HashSet<String> noTxPresent = new HashSet<String>();
        XaDataSourceManager dsManager = (XaDataSourceManager)targetDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class);
        for (XaDataSource ds : dsManager.getAllRegisteredDataSources()) {
            long lastTx = ds.getLastCommittedTxId();
            try {
                ds.getMasterForCommittedTx(lastTx);
            }
            catch (NoSuchLogVersionException e) {
                noTxPresent.add(ds.getName());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!noTxPresent.isEmpty()) {
            BackupClient recoveryClient = new BackupClient(sourceHostNameOrIp, sourcePort, (Logging)targetDb.getDependencyResolver().resolveDependency(Logging.class), (Monitors)targetDb.getDependencyResolver().resolveDependency(Monitors.class), targetDb.storeId());
            recoveryClient.start();
            Response<Void> recoveryResponse = null;
            HashMap<String, Long> recoveryDiff = new HashMap<String, Long>();
            for (String ds : noTxPresent) {
                recoveryDiff.put(ds, -1L);
            }
            RequestContext recoveryCtx = this.addDiffToSlaveContext(this.slaveContextOf(dsManager), recoveryDiff);
            try {
                recoveryResponse = recoveryClient.incrementalBackup(recoveryCtx);
                TransactionStream txs = recoveryResponse.transactions();
                ByteBuffer scratch = ByteBuffer.allocate(64);
                while (txs.hasNext()) {
                    Triplet tx = (Triplet)txs.next();
                    scratch.clear();
                    XaDataSource ds = dsManager.getXaDataSource((String)tx.first());
                    long logVersion = ds.getCurrentLogVersion() - 1L;
                    FileChannel newLog = new RandomAccessFile(ds.getFileName(logVersion), "rw").getChannel();
                    newLog.truncate(0L);
                    LogEntryWriterv1.writeLogHeader((ByteBuffer)scratch, (long)logVersion, (long)((Long)tx.second() - 1L));
                    newLog.write(scratch);
                    ReadableByteChannel received = ((TxExtractor)tx.third()).extract();
                    scratch.flip();
                    while (received.read(scratch) > 0) {
                        scratch.flip();
                        newLog.write(scratch);
                        scratch.flip();
                    }
                    newLog.force(false);
                    newLog.close();
                    received.close();
                }
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof NoSuchLogVersionException) {
                    this.logger.warn("Important: There are no available transaction logs on the target database, which means the backup could not save a point-in-time reference. This means you cannot use this backup for incremental backups, and it means you cannot use it directly to seed an HA cluster. The next time you perform a backup, a full backup will be done. If you wish to use this backup as a seed for a cluster, you need to start a stand-alone database on it, and commit one write transaction, to create the transaction log needed to seed the cluster. To avoid this happening, make sure you never manually delete transaction log files (nioneo_logical.log.vXXX), and that you configure the database to keep at least a few days worth of transaction logs.");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    recoveryClient.stop();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                if (recoveryResponse != null) {
                    recoveryResponse.close();
                }
                targetDb.shutdown();
            }
        }
    }

    private RequestContext slaveContextOf(XaDataSourceManager dsManager) {
        ArrayList<RequestContext.Tx> txs = new ArrayList<RequestContext.Tx>();
        for (XaDataSource ds : dsManager.getAllRegisteredDataSources()) {
            txs.add(RequestContext.lastAppliedTx((String)ds.getName(), (long)ds.getLastCommittedTxId()));
        }
        return RequestContext.anonymous((RequestContext.Tx[])txs.toArray(new RequestContext.Tx[txs.size()]));
    }

    private RequestContext addDiffToSlaveContext(RequestContext original, Map<String, Long> diffPerDataSource) {
        RequestContext.Tx[] oldTxs = original.lastAppliedTransactions();
        RequestContext.Tx[] newTxs = new RequestContext.Tx[oldTxs.length];
        for (int i = 0; i < oldTxs.length; ++i) {
            RequestContext.Tx oldTx = oldTxs[i];
            String dsName = oldTx.getDataSourceName();
            long originalTxId = oldTx.getTxId();
            Long diff = diffPerDataSource.get(dsName);
            if (diff == null) {
                diff = 0L;
            }
            long newTxId = originalTxId + diff;
            newTxs[i] = RequestContext.lastAppliedTx((String)dsName, (long)newTxId);
        }
        return RequestContext.anonymous((RequestContext.Tx[])newTxs);
    }
}

