/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.ToNetworkStoreWriter;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

class BackupClient
extends Client<TheBackupInterface>
implements TheBackupInterface {
    public BackupClient(String hostNameOrIp, int port, Logging logging, Monitors monitors, StoreId storeId) {
        super(hostNameOrIp, port, logging, monitors, storeId, 0x400000, new ProtocolVersion(1, 2), 40000L, 20, 0x400000);
    }

    @Override
    public Response<Void> fullBackup(StoreWriter storeWriter, final boolean forensics) {
        return this.sendRequest(BackupRequestType.FULL_BACKUP, RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeByte(forensics ? 1 : 0);
            }
        }, (Deserializer)new Protocol.FileStreamsDeserializer(storeWriter));
    }

    @Override
    public Response<Void> incrementalBackup(RequestContext context) {
        return this.sendRequest(BackupRequestType.INCREMENTAL_BACKUP, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    protected boolean shouldCheckStoreId(RequestType<TheBackupInterface> type) {
        return type != BackupRequestType.FULL_BACKUP;
    }

    public static enum BackupRequestType implements RequestType<TheBackupInterface>
    {
        FULL_BACKUP((TargetCaller)new TargetCaller<TheBackupInterface, Void>(){

            public Response<Void> call(TheBackupInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                boolean forensics = input.readable() ? this.booleanOf(input.readByte()) : false;
                return master.fullBackup((StoreWriter)new ToNetworkStoreWriter(target, new Monitors()), forensics);
            }

            private boolean booleanOf(byte value) {
                switch (value) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                throw new IllegalArgumentException("Invalid 'boolean' byte value " + value);
            }
        }, Protocol.VOID_SERIALIZER),
        INCREMENTAL_BACKUP((TargetCaller)new TargetCaller<TheBackupInterface, Void>(){

            public Response<Void> call(TheBackupInterface master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.incrementalBackup(context);
            }
        }, Protocol.VOID_SERIALIZER);

        private final TargetCaller masterCaller;
        private final ObjectSerializer serializer;

        private BackupRequestType(TargetCaller masterCaller, ObjectSerializer serializer) {
            this.masterCaller = masterCaller;
            this.serializer = serializer;
        }

        public TargetCaller getTargetCaller() {
            return this.masterCaller;
        }

        public ObjectSerializer getObjectSerializer() {
            return this.serializer;
        }

        public byte id() {
            return (byte)this.ordinal();
        }
    }
}

