/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.async.inbound;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CodecException;
import java.io.IOException;
import java.util.Objects;
import org.neo4j.driver.exceptions.ConnectionReadTimeoutException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.bolt.basicimpl.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.bolt.basicimpl.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.bolt.basicimpl.logging.ChannelErrorLogger;
import org.neo4j.driver.internal.util.ErrorUtil;

public class ChannelErrorHandler
extends ChannelInboundHandlerAdapter {
    private final LoggingProvider logging;
    private InboundMessageDispatcher messageDispatcher;
    private ChannelActivityLogger log;
    private ChannelErrorLogger errorLog;
    private boolean failed;

    public ChannelErrorHandler(LoggingProvider logging) {
        this.logging = logging;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.messageDispatcher = Objects.requireNonNull(ChannelAttributes.messageDispatcher(ctx.channel()));
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, ((Object)((Object)this)).getClass());
        this.errorLog = new ChannelErrorLogger(ctx.channel(), this.logging);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.messageDispatcher = null;
        this.log = null;
        this.failed = false;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.log.log(System.Logger.Level.DEBUG, "Channel is inactive");
        String terminationReason = ChannelAttributes.terminationReason(ctx.channel());
        ServiceUnavailableException error = ErrorUtil.newConnectionTerminatedError(terminationReason);
        if (!this.failed) {
            this.messageDispatcher.handleChannelInactive(error);
        } else {
            this.fail(error);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        if (this.failed) {
            this.errorLog.traceOrDebug("Another fatal error occurred in the pipeline", error);
        } else {
            this.failed = true;
            this.logUnexpectedErrorWarning(error);
            this.fail(error);
        }
    }

    private void logUnexpectedErrorWarning(Throwable error) {
        if (!(error instanceof ConnectionReadTimeoutException)) {
            this.errorLog.traceOrDebug("Fatal error occurred in the pipeline", error);
        }
    }

    private void fail(Throwable error) {
        Throwable cause = ChannelErrorHandler.transformError(error);
        this.messageDispatcher.handleChannelError(cause);
    }

    private static Throwable transformError(Throwable error) {
        if (error instanceof CodecException && error.getCause() != null) {
            error = error.getCause();
        }
        if (error instanceof IOException) {
            return new ServiceUnavailableException("Connection to the database failed", error);
        }
        return error;
    }
}

