/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.DomainNameResolver;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.MetricsListener;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.api.exception.MinVersionAcquisitionException;
import org.neo4j.driver.internal.bolt.basicimpl.BoltConnectionImpl;
import org.neo4j.driver.internal.bolt.basicimpl.ConnectionProvider;
import org.neo4j.driver.internal.bolt.basicimpl.ConnectionProviders;
import org.neo4j.driver.internal.bolt.basicimpl.NettyLogging;
import org.neo4j.driver.internal.bolt.basicimpl.NoopMetricsListener;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v51.BoltProtocolV51;
import org.neo4j.driver.internal.bolt.basicimpl.spi.Connection;
import org.neo4j.driver.internal.bolt.basicimpl.util.FutureUtil;

public final class NettyBoltConnectionProvider
implements BoltConnectionProvider {
    private final LoggingProvider logging;
    private final System.Logger log;
    private final ConnectionProvider connectionProvider;
    private BoltServerAddress address;
    private RoutingContext routingContext;
    private BoltAgent boltAgent;
    private String userAgent;
    private int connectTimeoutMillis;
    private CompletableFuture<Void> closeFuture;
    private MetricsListener metricsListener;
    private final Clock clock;

    public NettyBoltConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, DomainNameResolver domainNameResolver, LocalAddress localAddress, LoggingProvider logging) {
        Objects.requireNonNull(eventLoopGroup);
        this.clock = Objects.requireNonNull(clock);
        this.logging = Objects.requireNonNull(logging);
        this.log = logging.getLog(this.getClass());
        this.connectionProvider = ConnectionProviders.netty(eventLoopGroup, clock, domainNameResolver, localAddress, logging);
    }

    @Override
    public CompletionStage<Void> init(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener) {
        this.address = address;
        this.routingContext = routingContext;
        this.boltAgent = boltAgent;
        this.userAgent = userAgent;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.metricsListener = NoopMetricsListener.getInstance();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLogging(this.logging));
        return CompletableFuture.completedStage(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<BoltConnection> connect(SecurityPlan securityPlan, DatabaseName databaseName, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, AccessMode mode, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig, Consumer<DatabaseName> databaseNameConsumer) {
        NettyBoltConnectionProvider nettyBoltConnectionProvider = this;
        synchronized (nettyBoltConnectionProvider) {
            if (this.closeFuture != null) {
                return CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
            }
        }
        CompletableFuture latestAuthMillisFuture = new CompletableFuture();
        AtomicReference authMapRef = new AtomicReference();
        return authMapStageSupplier.get().thenCompose(authMap -> {
            authMapRef.set(authMap);
            return this.connectionProvider.acquireConnection(this.address, securityPlan, this.routingContext, databaseName != null ? (String)databaseName.databaseName().orElse(null) : null, (Map<String, Value>)authMap, this.boltAgent, this.userAgent, mode, this.connectTimeoutMillis, impersonatedUser, latestAuthMillisFuture, notificationConfig, this.metricsListener);
        }).thenCompose(connection -> {
            if (minVersion != null && minVersion.compareTo(connection.protocol().version()) > 0) {
                return connection.close().thenCompose(ignored -> CompletableFuture.failedStage(new MinVersionAcquisitionException("lower version", connection.protocol().version())));
            }
            return CompletableFuture.completedStage(connection);
        }).handle((connection, throwable) -> {
            if (throwable != null) {
                throwable = FutureUtil.completionExceptionCause(throwable);
                this.log.log(System.Logger.Level.DEBUG, "Failed to establish BoltConnection " + this.address, (Throwable)throwable);
                throw new CompletionException((Throwable)throwable);
            }
            databaseNameConsumer.accept(databaseName);
            return new BoltConnectionImpl(connection.protocol(), (Connection)connection, connection.eventLoop(), (Map)authMapRef.get(), latestAuthMillisFuture, this.routingContext, this.clock, this.logging);
        });
    }

    @Override
    public CompletionStage<Void> verifyConnectivity(SecurityPlan securityPlan, Map<String, Value> authMap) {
        return this.connect(securityPlan, null, () -> CompletableFuture.completedStage(authMap), AccessMode.WRITE, Collections.emptySet(), null, null, null, ignored -> {}).thenCompose(BoltConnection::close);
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb(SecurityPlan securityPlan, Map<String, Value> authMap) {
        return this.connect(securityPlan, null, () -> CompletableFuture.completedStage(authMap), AccessMode.WRITE, Collections.emptySet(), null, null, null, ignored -> {}).thenCompose(boltConnection -> {
            boolean supports = boltConnection.protocolVersion().compareTo(BoltProtocolV4.VERSION) >= 0;
            return boltConnection.close().thenApply(ignored -> supports);
        });
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth(SecurityPlan securityPlan, Map<String, Value> authMap) {
        return this.connect(securityPlan, null, () -> CompletableFuture.completedStage(authMap), AccessMode.WRITE, Collections.emptySet(), null, null, null, ignored -> {}).thenCompose(boltConnection -> {
            boolean supports = BoltProtocolV51.VERSION.compareTo(boltConnection.protocolVersion()) <= 0;
            return boltConnection.close().thenApply(ignored -> supports);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        NettyBoltConnectionProvider nettyBoltConnectionProvider = this;
        synchronized (nettyBoltConnectionProvider) {
            if (this.closeFuture == null) {
                this.closeFuture = CompletableFuture.completedFuture(null);
            }
            closeFuture = this.closeFuture;
        }
        return closeFuture;
    }
}

