/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.MongoChangeStreamCursorImpl;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperationCursor;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class ChangeStreamIterableImpl<TResult>
extends MongoIterableImpl<ChangeStreamDocument<TResult>>
implements ChangeStreamIterable<TResult> {
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private final Codec<ChangeStreamDocument<TResult>> codec;
    private final ChangeStreamLevel changeStreamLevel;
    private final Operations<TResult> operations;
    private FullDocument fullDocument = FullDocument.DEFAULT;
    private FullDocumentBeforeChange fullDocumentBeforeChange = FullDocumentBeforeChange.DEFAULT;
    private BsonDocument resumeToken;
    private BsonDocument startAfter;
    private long maxAwaitTimeMS;
    private Collation collation;
    private BsonTimestamp startAtOperationTime;
    private BsonValue comment;
    private boolean showExpandedEvents;

    public ChangeStreamIterableImpl(@Nullable ClientSession clientSession, String databaseName, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, List<? extends Bson> pipeline, Class<TResult> resultClass, ChangeStreamLevel changeStreamLevel, boolean retryReads, TimeoutSettings timeoutSettings) {
        this(clientSession, new MongoNamespace(databaseName, "_ignored"), codecRegistry, readPreference, readConcern, executor, pipeline, resultClass, changeStreamLevel, retryReads, timeoutSettings);
    }

    public ChangeStreamIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, List<? extends Bson> pipeline, Class<TResult> resultClass, ChangeStreamLevel changeStreamLevel, boolean retryReads, TimeoutSettings timeoutSettings) {
        super(clientSession, executor, readConcern, readPreference, retryReads, timeoutSettings);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
        this.codec = ChangeStreamDocument.createCodec((Class)((Class)Assertions.notNull((String)"resultClass", resultClass)), (CodecRegistry)codecRegistry);
        this.changeStreamLevel = (ChangeStreamLevel)Assertions.notNull((String)"changeStreamLevel", (Object)changeStreamLevel);
        this.operations = new Operations(namespace, resultClass, readPreference, codecRegistry, retryReads, timeoutSettings);
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocument(FullDocument fullDocument) {
        this.fullDocument = (FullDocument)Assertions.notNull((String)"fullDocument", (Object)fullDocument);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocumentBeforeChange(FullDocumentBeforeChange fullDocumentBeforeChange) {
        this.fullDocumentBeforeChange = (FullDocumentBeforeChange)Assertions.notNull((String)"fullDocumentBeforeChange", (Object)fullDocumentBeforeChange);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> resumeAfter(BsonDocument resumeAfter) {
        this.resumeToken = (BsonDocument)Assertions.notNull((String)"resumeAfter", (Object)resumeAfter);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.maxAwaitTimeMS = this.validateMaxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = (Collation)Assertions.notNull((String)"collation", (Object)collation);
        return this;
    }

    @Override
    public <TDocument> MongoIterable<TDocument> withDocumentClass(final Class<TDocument> clazz) {
        return new MongoIterableImpl<TDocument>(this.getClientSession(), this.getExecutor(), this.getReadConcern(), this.getReadPreference(), this.getRetryReads(), this.getTimeoutSettings()){

            @Override
            public MongoCursor<TDocument> iterator() {
                return this.cursor();
            }

            @Override
            public MongoChangeStreamCursor<TDocument> cursor() {
                return new MongoChangeStreamCursorImpl((BatchCursor<RawBsonDocument>)ChangeStreamIterableImpl.this.execute(), ChangeStreamIterableImpl.this.codecRegistry.get(clazz), ChangeStreamIterableImpl.this.initialResumeToken());
            }

            @Override
            public ReadOperationCursor<TDocument> asReadOperation() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected OperationExecutor getExecutor() {
                return ChangeStreamIterableImpl.this.getExecutor();
            }
        };
    }

    @Override
    public ChangeStreamIterable<TResult> startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTime = (BsonTimestamp)Assertions.notNull((String)"startAtOperationTime", (Object)startAtOperationTime);
        return this;
    }

    @Override
    public ChangeStreamIterableImpl<TResult> startAfter(BsonDocument startAfter) {
        this.startAfter = (BsonDocument)Assertions.notNull((String)"startAfter", (Object)startAfter);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> showExpandedEvents(boolean showExpandedEvents) {
        this.showExpandedEvents = showExpandedEvents;
        return this;
    }

    @Override
    public MongoCursor<ChangeStreamDocument<TResult>> iterator() {
        return this.cursor();
    }

    @Override
    public MongoChangeStreamCursor<ChangeStreamDocument<TResult>> cursor() {
        return new MongoChangeStreamCursorImpl<ChangeStreamDocument<TResult>>(this.execute(), this.codec, this.initialResumeToken());
    }

    @Override
    @Nullable
    public ChangeStreamDocument<TResult> first() {
        try (MongoCursor cursor = this.cursor();){
            if (!cursor.hasNext()) {
                ChangeStreamDocument<TResult> changeStreamDocument = null;
                return changeStreamDocument;
            }
            ChangeStreamDocument changeStreamDocument = (ChangeStreamDocument)cursor.next();
            return changeStreamDocument;
        }
    }

    @Override
    public ReadOperationCursor<ChangeStreamDocument<TResult>> asReadOperation() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(0L, this.maxAwaitTimeMS));
    }

    private ReadOperationCursor<RawBsonDocument> createChangeStreamOperation() {
        return this.operations.changeStream(this.fullDocument, this.fullDocumentBeforeChange, this.pipeline, (Decoder)new RawBsonDocumentCodec(), this.changeStreamLevel, this.getBatchSize(), this.collation, this.comment, this.resumeToken, this.startAtOperationTime, this.startAfter, this.showExpandedEvents);
    }

    private BatchCursor<RawBsonDocument> execute() {
        return (BatchCursor)this.getExecutor().execute(this.createChangeStreamOperation(), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    private BsonDocument initialResumeToken() {
        return this.startAfter != null ? this.startAfter : this.resumeToken;
    }
}

