/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperationCursor;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

final class DistinctPublisherImpl<T>
extends BatchCursorPublisher<T>
implements DistinctPublisher<T> {
    private final String fieldName;
    private Bson filter;
    private long maxTimeMS;
    private Collation collation;
    private BsonValue comment;
    private Bson hint;
    private String hintString;

    DistinctPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, String fieldName, Bson filter) {
        super(clientSession, mongoOperationPublisher);
        this.fieldName = (String)Assertions.notNull((String)"fieldName", (Object)fieldName);
        this.filter = (Bson)Assertions.notNull((String)"filter", (Object)filter);
    }

    @Override
    public DistinctPublisher<T> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public DistinctPublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public DistinctPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public DistinctPublisher<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public DistinctPublisher<T> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public DistinctPublisher<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public DistinctPublisher<T> hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public DistinctPublisher<T> hintString(@Nullable String hint) {
        this.hintString = hint;
        return this;
    }

    @Override
    public DistinctPublisher<T> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    ReadOperationCursor<T> asReadOperation(int initialBatchSize) {
        return this.getOperations().distinct(this.fieldName, this.filter, this.getDocumentClass(), this.collation, this.comment, this.hint, this.hintString);
    }

    @Override
    Function<Operations<?>, TimeoutSettings> getTimeoutSettings() {
        return operations -> operations.createTimeoutSettings(this.maxTimeMS);
    }
}

