/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.ReadOperationCursor;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.BatchCursor;
import com.mongodb.reactivestreams.client.internal.BatchCursorFlux;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bson.codecs.configuration.CodecRegistry;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;

public abstract class BatchCursorPublisher<T>
implements Publisher<T> {
    private final ClientSession clientSession;
    private final MongoOperationPublisher<T> mongoOperationPublisher;
    private Integer batchSize;
    private TimeoutMode timeoutMode;

    BatchCursorPublisher(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher) {
        this(clientSession, mongoOperationPublisher, null);
    }

    BatchCursorPublisher(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, @Nullable Integer batchSize) {
        this.clientSession = clientSession;
        this.mongoOperationPublisher = (MongoOperationPublisher)Assertions.notNull((String)"mongoOperationPublisher", mongoOperationPublisher);
        this.batchSize = batchSize;
    }

    abstract ReadOperationCursor<T> asReadOperation(int var1);

    abstract Function<Operations<?>, TimeoutSettings> getTimeoutSettings();

    ReadOperationCursor<T> asReadOperationFirst() {
        return this.asReadOperation(1);
    }

    @Nullable
    ClientSession getClientSession() {
        return this.clientSession;
    }

    MongoOperationPublisher<T> getMongoOperationPublisher() {
        return this.mongoOperationPublisher;
    }

    Operations<T> getOperations() {
        return this.mongoOperationPublisher.getOperations();
    }

    MongoNamespace getNamespace() {
        return (MongoNamespace)Assertions.assertNotNull((Object)this.mongoOperationPublisher.getNamespace());
    }

    ReadPreference getReadPreference() {
        return this.mongoOperationPublisher.getReadPreference();
    }

    CodecRegistry getCodecRegistry() {
        return this.mongoOperationPublisher.getCodecRegistry();
    }

    boolean getRetryReads() {
        return this.mongoOperationPublisher.getRetryReads();
    }

    Class<T> getDocumentClass() {
        return this.mongoOperationPublisher.getDocumentClass();
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Publisher<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Publisher<T> timeoutMode(TimeoutMode timeoutMode) {
        if (this.mongoOperationPublisher.getTimeoutSettings().getTimeoutMS() == null) {
            throw new IllegalArgumentException("TimeoutMode requires timeoutMS to be set.");
        }
        this.timeoutMode = timeoutMode;
        return this;
    }

    @Nullable
    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    public Publisher<T> first() {
        return this.batchCursor(this::asReadOperationFirst).flatMap(batchCursor -> {
            batchCursor.setBatchSize(1);
            return Mono.from(batchCursor.next()).doOnTerminate(batchCursor::close).flatMap(results -> {
                if (results == null || results.isEmpty()) {
                    return Mono.empty();
                }
                return Mono.fromCallable(() -> results.get(0));
            });
        });
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        new BatchCursorFlux<T>(this).subscribe(subscriber);
    }

    public Mono<BatchCursor<T>> batchCursor(int initialBatchSize) {
        return this.batchCursor(() -> this.asReadOperation(initialBatchSize));
    }

    Mono<BatchCursor<T>> batchCursor(Supplier<ReadOperation<?, AsyncBatchCursor<T>>> supplier) {
        return this.mongoOperationPublisher.createReadOperationMono(this.getTimeoutSettings(), supplier, this.clientSession).map(BatchCursor::new);
    }

    protected long validateMaxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        Long timeoutMS = this.mongoOperationPublisher.getTimeoutSettings().getTimeoutMS();
        long maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        Assertions.isTrueArgument((String)"maxAwaitTimeMS must be less than timeoutMS", (timeoutMS == null || timeoutMS == 0L || timeoutMS > maxAwaitTimeMS ? 1 : 0) != 0);
        return maxAwaitTimeMS;
    }
}

