/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListCollectionNamesPublisher;
import com.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

@ThreadSafe
public interface MongoDatabase {
    public String getName();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout(TimeUnit var1);

    public MongoDatabase withCodecRegistry(CodecRegistry var1);

    public MongoDatabase withReadPreference(ReadPreference var1);

    public MongoDatabase withWriteConcern(WriteConcern var1);

    public MongoDatabase withReadConcern(ReadConcern var1);

    @Alpha(value={Reason.CLIENT})
    public MongoDatabase withTimeout(long var1, TimeUnit var3);

    public MongoCollection<Document> getCollection(String var1);

    public <TDocument> MongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public Publisher<Document> runCommand(Bson var1);

    public Publisher<Document> runCommand(Bson var1, ReadPreference var2);

    public <TResult> Publisher<TResult> runCommand(Bson var1, Class<TResult> var2);

    public <TResult> Publisher<TResult> runCommand(Bson var1, ReadPreference var2, Class<TResult> var3);

    public Publisher<Document> runCommand(ClientSession var1, Bson var2);

    public Publisher<Document> runCommand(ClientSession var1, Bson var2, ReadPreference var3);

    public <TResult> Publisher<TResult> runCommand(ClientSession var1, Bson var2, Class<TResult> var3);

    public <TResult> Publisher<TResult> runCommand(ClientSession var1, Bson var2, ReadPreference var3, Class<TResult> var4);

    public Publisher<Void> drop();

    public Publisher<Void> drop(ClientSession var1);

    public ListCollectionNamesPublisher listCollectionNames();

    public ListCollectionNamesPublisher listCollectionNames(ClientSession var1);

    public ListCollectionsPublisher<Document> listCollections();

    public <TResult> ListCollectionsPublisher<TResult> listCollections(Class<TResult> var1);

    public ListCollectionsPublisher<Document> listCollections(ClientSession var1);

    public <TResult> ListCollectionsPublisher<TResult> listCollections(ClientSession var1, Class<TResult> var2);

    public Publisher<Void> createCollection(String var1);

    public Publisher<Void> createCollection(String var1, CreateCollectionOptions var2);

    public Publisher<Void> createCollection(ClientSession var1, String var2);

    public Publisher<Void> createCollection(ClientSession var1, String var2, CreateCollectionOptions var3);

    public Publisher<Void> createView(String var1, String var2, List<? extends Bson> var3);

    public Publisher<Void> createView(String var1, String var2, List<? extends Bson> var3, CreateViewOptions var4);

    public Publisher<Void> createView(ClientSession var1, String var2, String var3, List<? extends Bson> var4);

    public Publisher<Void> createView(ClientSession var1, String var2, String var3, List<? extends Bson> var4, CreateViewOptions var5);

    public ChangeStreamPublisher<Document> watch();

    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> var1);

    public ChangeStreamPublisher<Document> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public AggregatePublisher<Document> aggregate(List<? extends Bson> var1);

    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public AggregatePublisher<Document> aggregate(ClientSession var1, List<? extends Bson> var2);

    public <TResult> AggregatePublisher<TResult> aggregate(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);
}

