/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.gridfs;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.internal.time.Timeout;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadPublisher;
import com.mongodb.reactivestreams.client.internal.gridfs.GridFSPublisherCreator;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

public final class GridFSBucketImpl
implements GridFSBucket {
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private final String bucketName;
    private final int chunkSizeBytes;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;

    public GridFSBucketImpl(MongoDatabase database) {
        this(database, "fs");
    }

    public GridFSBucketImpl(MongoDatabase database, String bucketName) {
        this((String)Assertions.notNull((String)"bucketName", (Object)bucketName), 261120, GridFSBucketImpl.getFilesCollection((MongoDatabase)Assertions.notNull((String)"database", (Object)database), bucketName), GridFSBucketImpl.getChunksCollection(database, bucketName));
    }

    private GridFSBucketImpl(String bucketName, int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection) {
        this.bucketName = (String)Assertions.notNull((String)"bucketName", (Object)bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = (MongoCollection)Assertions.notNull((String)"filesCollection", filesCollection);
        this.chunksCollection = (MongoCollection)Assertions.notNull((String)"chunksCollection", chunksCollection);
    }

    private static MongoCollection<GridFSFile> getFilesCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{database.getCodecRegistry(), MongoClients.getDefaultCodecRegistry()}));
    }

    private static MongoCollection<Document> getChunksCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks").withCodecRegistry(MongoClients.getDefaultCodecRegistry());
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        Long timeoutMS = this.filesCollection.getTimeout(TimeUnit.MILLISECONDS);
        return timeoutMS == null ? null : Long.valueOf(((TimeUnit)((Object)Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit)))).convert(timeoutMS, TimeUnit.MILLISECONDS));
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        Assertions.notNull((String)"readConcern", (Object)readConcern);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    @Override
    public GridFSBucket withTimeout(long timeout, TimeUnit timeUnit) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withTimeout(timeout, timeUnit), this.chunksCollection.withTimeout(timeout, timeUnit));
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, null, (BsonValue)new BsonObjectId(), filename, options, source).withObjectId();
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(BsonValue id, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(id, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(BsonValue id, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, null, id, filename, options, source);
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(ClientSession clientSession, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(clientSession, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(ClientSession clientSession, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), (BsonValue)new BsonObjectId(), filename, options, source).withObjectId();
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(ClientSession clientSession, BsonValue id, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(clientSession, id, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(ClientSession clientSession, BsonValue id, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), id, filename, options, source);
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ObjectId id) {
        return this.downloadToPublisher((BsonValue)new BsonObjectId(id));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(BsonValue id) {
        Function<Timeout, GridFSFindPublisher> findPublisherCreator = operationTimeout -> GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, (Bson)new BsonDocument("_id", id), operationTimeout);
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, null, findPublisherCreator);
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(String filename) {
        return this.downloadToPublisher(filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(String filename, GridFSDownloadOptions options) {
        Function<Timeout, GridFSFindPublisher> findPublisherCreator = operationTimeout -> GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, filename, options, operationTimeout);
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, null, findPublisherCreator);
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, ObjectId id) {
        return this.downloadToPublisher(clientSession, (BsonValue)new BsonObjectId(id));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, BsonValue id) {
        Function<Timeout, GridFSFindPublisher> findPublisherCreator = operationTimeout -> GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, clientSession, (Bson)new BsonDocument("_id", id), operationTimeout);
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), findPublisherCreator);
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, String filename) {
        return this.downloadToPublisher(clientSession, filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        Function<Timeout, GridFSFindPublisher> findPublisherCreator = operationTimeout -> GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, clientSession, filename, options, operationTimeout);
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), findPublisherCreator);
    }

    @Override
    public GridFSFindPublisher find() {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, null);
    }

    @Override
    public GridFSFindPublisher find(Bson filter) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, (Bson)Assertions.notNull((String)"filter", (Object)filter));
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), null);
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession, Bson filter) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), (Bson)Assertions.notNull((String)"filter", (Object)filter));
    }

    @Override
    public Publisher<Void> delete(ObjectId id) {
        return this.delete((BsonValue)new BsonObjectId(id));
    }

    @Override
    public Publisher<Void> delete(BsonValue id) {
        return GridFSPublisherCreator.createDeletePublisher(this.filesCollection, this.chunksCollection, null, id);
    }

    @Override
    public Publisher<Void> delete(ClientSession clientSession, ObjectId id) {
        return this.delete(clientSession, (BsonValue)new BsonObjectId(id));
    }

    @Override
    public Publisher<Void> delete(ClientSession clientSession, BsonValue id) {
        return GridFSPublisherCreator.createDeletePublisher(this.filesCollection, this.chunksCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), id);
    }

    @Override
    public Publisher<Void> rename(ObjectId id, String newFilename) {
        return this.rename((BsonValue)new BsonObjectId(id), newFilename);
    }

    @Override
    public Publisher<Void> rename(BsonValue id, String newFilename) {
        return GridFSPublisherCreator.createRenamePublisher(this.filesCollection, null, id, newFilename);
    }

    @Override
    public Publisher<Void> rename(ClientSession clientSession, ObjectId id, String newFilename) {
        return this.rename(clientSession, (BsonValue)new BsonObjectId(id), newFilename);
    }

    @Override
    public Publisher<Void> rename(ClientSession clientSession, BsonValue id, String newFilename) {
        return GridFSPublisherCreator.createRenamePublisher(this.filesCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), id, newFilename);
    }

    @Override
    public Publisher<Void> drop() {
        return GridFSPublisherCreator.createDropPublisher(this.filesCollection, this.chunksCollection, null);
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return GridFSPublisherCreator.createDropPublisher(this.filesCollection, this.chunksCollection, (ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession));
    }
}

