/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ListCollectionNamesPublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.ListCollectionsPublisherImpl;
import java.util.concurrent.TimeUnit;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ListCollectionNamesPublisherImpl
implements ListCollectionNamesPublisher {
    private final ListCollectionsPublisherImpl<Document> wrapped;
    private final Flux<String> wrappedWithMapping;

    ListCollectionNamesPublisherImpl(ListCollectionsPublisherImpl<Document> wrapped) {
        this.wrapped = wrapped;
        this.wrappedWithMapping = Flux.from(wrapped).map(ListCollectionNamesPublisherImpl::name);
    }

    @Override
    public ListCollectionNamesPublisher maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionNamesPublisher batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public ListCollectionNamesPublisher filter(@Nullable Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public ListCollectionNamesPublisher comment(@Nullable String comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public ListCollectionNamesPublisher comment(@Nullable BsonValue comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public ListCollectionNamesPublisher authorizedCollections(boolean authorizedCollections) {
        this.wrapped.authorizedCollections(authorizedCollections);
        return this;
    }

    @Override
    public Publisher<String> first() {
        return Mono.fromDirect(this.wrapped.first()).map(ListCollectionNamesPublisherImpl::name);
    }

    public void subscribe(Subscriber<? super String> subscriber) {
        this.wrappedWithMapping.subscribe(subscriber);
    }

    public BatchCursorPublisher<Document> getWrapped() {
        return this.wrapped;
    }

    private static String name(Document collectionDoc) {
        return collectionDoc.getString((Object)"name");
    }
}

