/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperationSimple;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class CountOperation
implements ReadOperationSimple<Long> {
    private static final String COMMAND_NAME = "count";
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonDocument filter;
    private BsonValue hint;
    private long skip;
    private long limit;
    private Collation collation;

    public CountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountOperation filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public CountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public CountOperation hint(BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountOperation limit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountOperation skip(long skip) {
        this.skip = skip;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CountOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public Long execute(ReadBinding binding) {
        return SyncOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), DECODER, this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), DECODER, this.asyncTransformer(), this.retryReads, callback);
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result, source, connection) -> result.getNumber((Object)"n").longValue();
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result, source, connection) -> result.getNumber((Object)"n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument document = new BsonDocument(this.getCommandName(), (BsonValue)new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), document);
            DocumentHelper.putIfNotNull(document, "query", (BsonValue)this.filter);
            DocumentHelper.putIfNotZero(document, "limit", this.limit);
            DocumentHelper.putIfNotZero(document, "skip", this.skip);
            DocumentHelper.putIfNotNull(document, "hint", this.hint);
            if (this.collation != null) {
                document.put("collation", (BsonValue)this.collation.asDocument());
            }
            return document;
        };
    }
}

