/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client;

import com.mongodb.internal.client.DriverInformation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class DriverInformationHelper {
    public static final DriverInformation INITIAL_DRIVER_INFORMATION = new DriverInformation("mongo-java-driver", "5.6.2", String.format("Java/%s/%s", System.getProperty("java.vendor", "unknown-vendor"), System.getProperty("java.runtime.version", "unknown-version")));

    public static List<String> getNames(List<DriverInformation> driverInformation) {
        return DriverInformationHelper.getDriverField(DriverInformation::getDriverName, driverInformation);
    }

    public static List<String> getVersions(List<DriverInformation> driverInformation) {
        return DriverInformationHelper.getDriverField(DriverInformation::getDriverVersion, driverInformation);
    }

    public static List<String> getPlatforms(List<DriverInformation> driverInformation) {
        return DriverInformationHelper.getDriverField(DriverInformation::getDriverPlatform, driverInformation);
    }

    private static List<String> getDriverField(Function<DriverInformation, String> fieldSupplier, List<DriverInformation> driverInformation) {
        return Collections.unmodifiableList(driverInformation.stream().map(fieldSupplier).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private DriverInformationHelper() {
    }
}

