/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.junit.jupiter;

import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.internal.configuration.MockAnnotationProcessor;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.session.MockitoSessionLoggerAdapter;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.session.MockitoSessionLogger;

public class MockitoExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace MOCKITO = ExtensionContext.Namespace.create((Object[])new Object[]{"org.mockito"});
    private static final String SESSION = "session";
    private final Strictness strictness;

    public MockitoExtension() {
        this(Strictness.STRICT_STUBS);
    }

    private MockitoExtension(Strictness strictness) {
        this.strictness = strictness;
    }

    public void beforeEach(ExtensionContext context) {
        List testInstances = context.getRequiredTestInstances().getAllInstances();
        Strictness actualStrictness = this.retrieveAnnotationFromTestClasses(context).map(MockitoSettings::strictness).orElse(this.strictness);
        MockitoSession session = Mockito.mockitoSession().initMocks(testInstances.toArray()).strictness(actualStrictness).logger((MockitoSessionLogger)new MockitoSessionLoggerAdapter(Plugins.getMockitoLogger())).startMocking();
        context.getStore(MOCKITO).put((Object)SESSION, (Object)session);
    }

    private Optional<MockitoSettings> retrieveAnnotationFromTestClasses(ExtensionContext context) {
        Optional annotation;
        ExtensionContext currentContext = context;
        do {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.getElement(), MockitoSettings.class);
            if (!currentContext.getParent().isPresent()) break;
            currentContext = (ExtensionContext)currentContext.getParent().get();
        } while (!annotation.isPresent() && currentContext != context.getRoot());
        return annotation;
    }

    public void afterEach(ExtensionContext context) {
        ((MockitoSession)context.getStore(MOCKITO).remove((Object)SESSION, MockitoSession.class)).finishMocking();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(Mock.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        return MockAnnotationProcessor.processAnnotationForMock((Mock)((Mock)parameterContext.findAnnotation(Mock.class).get()), parameter.getType(), (String)parameter.getName());
    }
}

