/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.streams;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class IOStreamUtils {
    private final MockServerLogger mockServerLogger;

    public IOStreamUtils(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public static String readHttpInputStreamToString(Socket socket) {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            StringBuilder result = new StringBuilder();
            Integer contentLength = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("content-length") || line.startsWith("Content-Length")) {
                    contentLength = Integer.parseInt(line.split(":")[1].trim());
                }
                if (line.length() == 0) {
                    if (contentLength == null) break;
                    result.append(Character.NEW_LINE);
                    for (int position = 0; position < contentLength; ++position) {
                        result.append((char)bufferedReader.read());
                    }
                    break;
                }
                result.append(line).append(Character.NEW_LINE);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readSocketToString(Socket socket) {
        StringBuilder result = new StringBuilder();
        try {
            InputStream inputStream = socket.getInputStream();
            do {
                byte[] buffer = new byte[10000];
                int readBytes = inputStream.read(buffer);
                result.append(new String(Arrays.copyOfRange(buffer, 0, readBytes), StandardCharsets.UTF_8));
            } while (inputStream.available() > 0);
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readHttpInputStreamToString(ServletRequest request) {
        try {
            return new String(ByteStreams.toByteArray((InputStream)request.getInputStream()), request.getCharacterEncoding() != null ? request.getCharacterEncoding() : StandardCharsets.UTF_8.name());
        }
        catch (IOException ioe) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("IOException while reading HttpServletRequest input stream").setThrowable(ioe));
            throw new RuntimeException("IOException while reading HttpServletRequest input stream", ioe);
        }
    }

    public void writeToOutputStream(byte[] data, ServletResponse response) {
        try {
            ServletOutputStream output = response.getOutputStream();
            output.write(data);
            output.close();
        }
        catch (IOException ioe) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("IOException while writing [" + new String(data) + "] to HttpServletResponse output stream").setThrowable(ioe));
            throw new RuntimeException("IOException while writing [" + new String(data) + "] to HttpServletResponse output stream", ioe);
        }
    }
}

