/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.log;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;

public class LogEntrySerializer
extends StdSerializer<LogEntry> {
    public LogEntrySerializer() {
        super(LogEntry.class);
    }

    public void serialize(LogEntry logEntry, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (logEntry.getLogLevel() != null) {
            jgen.writeObjectField("logLevel", (Object)logEntry.getLogLevel());
        }
        if (logEntry.getTimestamp() != null) {
            jgen.writeObjectField("timestamp", (Object)logEntry.getTimestamp());
        }
        if (logEntry.getType() != null) {
            jgen.writeObjectField("type", (Object)logEntry.getType());
        }
        if (logEntry.getHttpRequests() != null) {
            if (logEntry.getHttpRequests().length > 1) {
                jgen.writeObjectField("httpRequests", (Object)logEntry.getHttpUpdatedRequests());
            } else if (logEntry.getHttpRequests().length == 1) {
                jgen.writeObjectField("httpRequest", (Object)logEntry.getHttpUpdatedRequests()[0]);
            }
        }
        if (logEntry.getHttpResponse() != null) {
            jgen.writeObjectField("httpResponse", (Object)logEntry.getHttpUpdatedResponse());
        }
        if (logEntry.getHttpError() != null) {
            jgen.writeObjectField("httpError", (Object)logEntry.getHttpError());
        }
        if (logEntry.getExpectation() != null) {
            jgen.writeObjectField("expectation", (Object)logEntry.getExpectation());
        }
        if (logEntry.getMessage() != null) {
            jgen.writeObjectField("message", (Object)logEntry.getMessage().replaceAll(" {2}", "   ").split(Character.NEW_LINE));
        }
        if (logEntry.getThrowable() != null) {
            jgen.writeObjectField("throwable", (Object)logEntry.getThrowable());
        }
        jgen.writeEndObject();
    }
}

