/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.expectation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mockserver.serialization.model.OpenAPIExpectationDTO;

public class OpenAPIExpectationDTODeserializer
extends StdDeserializer<OpenAPIExpectationDTO> {
    public OpenAPIExpectationDTODeserializer() {
        super(OpenAPIExpectationDTO.class);
    }

    public OpenAPIExpectationDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            String specUrlOrPayload = null;
            HashMap operationsAndResponses = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName;
                switch (fieldName = jsonParser.getCurrentName()) {
                    case "specUrlOrPayload": {
                        jsonParser.nextToken();
                        JsonNode specUrlOrPayloadField = (JsonNode)ctxt.readValue(jsonParser, JsonNode.class);
                        if (specUrlOrPayloadField.isTextual()) {
                            specUrlOrPayload = specUrlOrPayloadField.asText();
                            break;
                        }
                        specUrlOrPayload = specUrlOrPayloadField.toPrettyString();
                        break;
                    }
                    case "operationsAndResponses": {
                        jsonParser.nextToken();
                        HashMap value = new HashMap();
                        Map map = (Map)ctxt.readValue(jsonParser, Map.class);
                        map.keySet().forEach(key -> {
                            if (key instanceof String && map.get(key) instanceof String) {
                                value.put((String)key, (String)map.get(key));
                            }
                        });
                        if (value.isEmpty()) break;
                        operationsAndResponses = value;
                    }
                }
            }
            return new OpenAPIExpectationDTO().setSpecUrlOrPayload(specUrlOrPayload).setOperationsAndResponses(operationsAndResponses);
        }
        return null;
    }
}

