/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.persistence;

import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mockserver.configuration.Configuration;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.persistence.FileWatcher;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.server.initialize.ExpectationInitializerLoader;
import org.slf4j.event.Level;

public class ExpectationFileWatcher {
    private final Configuration configuration;
    private final ExpectationInitializerLoader expectationInitializerLoader;
    private final MockServerLogger mockServerLogger;
    private final RequestMatchers requestMatchers;
    private final ExpectationSerializer expectationSerializer;
    private List<FileWatcher> fileWatchers;

    public ExpectationFileWatcher(Configuration configuration, MockServerLogger mockServerLogger, RequestMatchers requestMatchers, ExpectationInitializerLoader expectationInitializerLoader) {
        this.configuration = configuration;
        if (configuration.watchInitializationJson().booleanValue()) {
            this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
            this.mockServerLogger = mockServerLogger;
            this.requestMatchers = requestMatchers;
            this.expectationInitializerLoader = expectationInitializerLoader;
            List<String> initializationJsonPaths = ExpectationInitializerLoader.expandedInitializationJsonPaths(configuration.initializationJsonPath());
            try {
                this.fileWatchers = initializationJsonPaths.stream().map(initializationJsonPath -> {
                    try {
                        return new FileWatcher(Paths.get(initializationJsonPath, new String[0]), () -> {
                            if (MockServerLogger.isEnabled(Level.DEBUG) && mockServerLogger != null) {
                                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("expectation file watcher updating expectations as modification detected on file{}").setArguments(configuration.initializationJsonPath()));
                            }
                            this.addExpectationsFromInitializer();
                        }, throwable -> {
                            if (MockServerLogger.isEnabled(Level.WARN) && mockServerLogger != null) {
                                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception while processing expectation file update " + throwable.getMessage()).setThrowable((Throwable)throwable));
                            }
                        }, mockServerLogger);
                    }
                    catch (Throwable throwable2) {
                        mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception creating file watcher for{}").setArguments(initializationJsonPath).setThrowable(throwable2));
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception creating file watchers for{}").setArguments(initializationJsonPaths).setThrowable(throwable));
            }
            if (MockServerLogger.isEnabled(Level.INFO) && mockServerLogger != null) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("created expectation file watcher for{}").setArguments(initializationJsonPaths));
            }
        } else {
            this.expectationSerializer = null;
            this.mockServerLogger = null;
            this.requestMatchers = null;
            this.expectationInitializerLoader = null;
        }
    }

    private synchronized void addExpectationsFromInitializer() {
        this.expectationInitializerLoader.retrieveExpectationsFromFile("", "exception while loading JSON initialization file with file watcher, ignoring file:{}", "updating expectations:{}from file:{}", MockServerMatcherNotifier.Cause.Type.FILE_INITIALISER);
    }

    public void stop() {
        if (this.fileWatchers != null) {
            this.fileWatchers.forEach(fileWatcher -> fileWatcher.setRunning(false));
        }
    }
}

