/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.List;
import java.util.Objects;
import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.CookiesModifier;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HeadersModifier;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;
import org.mockserver.model.PathModifier;
import org.mockserver.model.QueryParametersModifier;

public class HttpRequestModifier
extends ObjectWithJsonToString {
    private int hashCode;
    private PathModifier path;
    private QueryParametersModifier queryStringParameters;
    private HeadersModifier headers;
    private CookiesModifier cookies;

    public static HttpRequestModifier requestModifier() {
        return new HttpRequestModifier();
    }

    public PathModifier getPath() {
        return this.path;
    }

    public HttpRequestModifier withPath(PathModifier path) {
        this.path = path;
        this.hashCode = 0;
        return this;
    }

    public HttpRequestModifier withPath(String regex, String substitution) {
        this.path = new PathModifier().withRegex(regex).withSubstitution(substitution);
        this.hashCode = 0;
        return this;
    }

    public QueryParametersModifier getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequestModifier withQueryStringParameters(QueryParametersModifier queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        this.hashCode = 0;
        return this;
    }

    public HttpRequestModifier withQueryStringParameters(Parameters add, Parameters replace, List<String> remove) {
        this.queryStringParameters = (QueryParametersModifier)((QueryParametersModifier)((QueryParametersModifier)new QueryParametersModifier().withAdd(add)).withReplace(replace)).withRemove(remove);
        this.hashCode = 0;
        return this;
    }

    public HttpRequestModifier withQueryStringParameters(List<Parameter> add, List<Parameter> replace, List<String> remove) {
        this.queryStringParameters = (QueryParametersModifier)((QueryParametersModifier)((QueryParametersModifier)new QueryParametersModifier().withAdd(new Parameters(add))).withReplace(new Parameters(replace))).withRemove(remove);
        this.hashCode = 0;
        return this;
    }

    public HeadersModifier getHeaders() {
        return this.headers;
    }

    public HttpRequestModifier withHeaders(HeadersModifier headers) {
        this.headers = headers;
        this.hashCode = 0;
        return this;
    }

    public HttpRequestModifier withHeaders(List<Header> add, List<Header> replace, List<String> remove) {
        this.headers = (HeadersModifier)((HeadersModifier)((HeadersModifier)new HeadersModifier().withAdd(new Headers(add))).withReplace(new Headers(replace))).withRemove(remove);
        this.hashCode = 0;
        return this;
    }

    public CookiesModifier getCookies() {
        return this.cookies;
    }

    public HttpRequestModifier withCookies(CookiesModifier cookies) {
        this.cookies = cookies;
        this.hashCode = 0;
        return this;
    }

    public HttpRequestModifier withCookies(List<Cookie> add, List<Cookie> replace, List<String> remove) {
        this.cookies = (CookiesModifier)((CookiesModifier)((CookiesModifier)new CookiesModifier().withAdd(new Cookies(add))).withReplace(new Cookies(replace))).withRemove(remove);
        this.hashCode = 0;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        HttpRequestModifier that = (HttpRequestModifier)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.queryStringParameters, that.queryStringParameters) && Objects.equals(this.headers, that.headers) && Objects.equals(this.cookies, that.cookies);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.path, this.queryStringParameters, this.headers, this.cookies);
        }
        return this.hashCode;
    }
}

