/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.mockserver.model.Action;

public class HttpForward
extends Action<HttpForward> {
    private int hashCode;
    private String host;
    private Integer port = 80;
    private Scheme scheme = Scheme.HTTP;

    public static HttpForward forward() {
        return new HttpForward();
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.FORWARD;
    }

    public String getHost() {
        return this.host;
    }

    public HttpForward withHost(String host) {
        this.host = host;
        this.hashCode = 0;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public HttpForward withPort(Integer port) {
        this.port = port;
        this.hashCode = 0;
        return this;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public HttpForward withScheme(Scheme scheme) {
        this.scheme = scheme;
        this.hashCode = 0;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpForward that = (HttpForward)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && this.scheme == that.scheme;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(new Object[]{super.hashCode(), this.host, this.port, this.scheme});
        }
        return this.hashCode;
    }

    public static enum Scheme {
        HTTP,
        HTTPS;

    }
}

