/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.memory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mockserver.character.Character;
import org.mockserver.configuration.Configuration;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.memory.Summary;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerLogListener;
import org.mockserver.mock.listeners.MockServerMatcherListener;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;

public class MemoryMonitoring
implements MockServerLogListener,
MockServerMatcherListener {
    private static final AtomicInteger memoryUpdateFrequency = new AtomicInteger(0);
    private static final AtomicInteger currentLogEntriesCount = new AtomicInteger(0);
    private static final AtomicInteger currentExpectationsCount = new AtomicInteger(0);
    private static final List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
    private final Configuration configuration;
    private final File csvFile;

    public MemoryMonitoring(Configuration configuration, MockServerEventLog mockServerLog, RequestMatchers requestMatchers) {
        if (configuration.outputMemoryUsageCsv().booleanValue()) {
            this.configuration = configuration;
            this.csvFile = new File(configuration.memoryUsageCsvDirectory(), "memoryUsage_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".csv");
            if (!this.csvFile.exists()) {
                String line = this.buildStatistics().stream().map(Pair::getKey).collect(Collectors.joining(","));
                this.writeLineToCsv(line);
            }
            if (mockServerLog != null) {
                mockServerLog.registerListener(this);
            }
            if (requestMatchers != null) {
                requestMatchers.registerListener(this);
            }
        } else {
            this.configuration = null;
            this.csvFile = null;
        }
    }

    public static Summary getJVMMemory(MemoryType heap) {
        return new Summary(memoryPoolMXBeans.stream().filter(bean -> bean.getType() == heap).collect(Collectors.toList()));
    }

    public void logMemoryMetrics() {
        if (this.configuration.outputMemoryUsageCsv().booleanValue()) {
            String line = this.buildStatistics().stream().map(Pair::getValue).map(String::valueOf).collect(Collectors.joining(","));
            this.writeLineToCsv(line);
        }
    }

    private void writeLineToCsv(String line) {
        try {
            FileOutputStream rawFileOutputStream = new FileOutputStream(this.csvFile, true);
            rawFileOutputStream.write((line + Character.NEW_LINE).getBytes(StandardCharsets.UTF_8));
            rawFileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<ImmutablePair<String, Object>> buildStatistics() {
        Summary heap = MemoryMonitoring.getJVMMemory(MemoryType.HEAP);
        Summary nonHeap = MemoryMonitoring.getJVMMemory(MemoryType.NON_HEAP);
        ArrayList<ImmutablePair<String, Object>> memoryStatistics = new ArrayList<ImmutablePair<String, Object>>();
        memoryStatistics.add(ImmutablePair.of((Object)"mockServerPort", (Object)HttpState.getPort()));
        memoryStatistics.add(ImmutablePair.of((Object)"eventLogSize", (Object)currentLogEntriesCount.get()));
        memoryStatistics.add(ImmutablePair.of((Object)"maxLogEntries", (Object)this.configuration.maxLogEntries()));
        memoryStatistics.add(ImmutablePair.of((Object)"expectationsSize", (Object)currentExpectationsCount.get()));
        memoryStatistics.add(ImmutablePair.of((Object)"maxExpectations", (Object)this.configuration.maxExpectations()));
        memoryStatistics.add(ImmutablePair.of((Object)"heapInitialAllocation", (Object)heap.getNet().getInit()));
        memoryStatistics.add(ImmutablePair.of((Object)"heapUsed", (Object)heap.getNet().getUsed()));
        memoryStatistics.add(ImmutablePair.of((Object)"heapCommitted", (Object)heap.getNet().getCommitted()));
        memoryStatistics.add(ImmutablePair.of((Object)"heapMaxAllowed", (Object)heap.getNet().getMax()));
        memoryStatistics.add(ImmutablePair.of((Object)"nonHeapInitialAllocation", (Object)nonHeap.getNet().getInit()));
        memoryStatistics.add(ImmutablePair.of((Object)"nonHeapUsed", (Object)nonHeap.getNet().getUsed()));
        memoryStatistics.add(ImmutablePair.of((Object)"nonHeapCommitted", (Object)nonHeap.getNet().getCommitted()));
        memoryStatistics.add(ImmutablePair.of((Object)"nonHeapMaxAllowed", (Object)nonHeap.getNet().getMax()));
        return memoryStatistics;
    }

    @Override
    public void updated(MockServerEventLog mockServerLog) {
        currentLogEntriesCount.set(mockServerLog.size());
        if (this.shouldLogMetrics()) {
            this.logMemoryMetrics();
        }
    }

    @Override
    public void updated(RequestMatchers requestMatchers, MockServerMatcherNotifier.Cause cause) {
        currentExpectationsCount.set(requestMatchers.size());
        if (this.shouldLogMetrics()) {
            this.logMemoryMetrics();
        }
    }

    private boolean shouldLogMetrics() {
        return memoryUpdateFrequency.incrementAndGet() % 50 == 0;
    }
}

