/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.Matcher;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class BooleanMatcher
extends ObjectWithReflectiveEqualsHashCodeToString
implements Matcher<Boolean> {
    private static final String[] excludedFields = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final Boolean matcher;

    BooleanMatcher(MockServerLogger mockServerLogger, Boolean matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
    }

    @Override
    public boolean matches(MatchDifference context, Boolean matched) {
        boolean result = false;
        if (this.matcher == null) {
            result = true;
        } else if (matched != null) {
            boolean bl = result = matched == this.matcher;
        }
        if (!result && context != null) {
            context.addDifference(this.mockServerLogger, "boolean match failed expected:{}found:{}", this.matcher, matched);
        }
        return result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null;
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

