/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import org.mockserver.codec.MockServerHttpServerCodec;
import org.mockserver.configuration.Configuration;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.echo.http.EchoServerHandler;
import org.mockserver.echo.http.EchoServerHttpOrHttp2Initializer;
import org.mockserver.echo.http.EchoWebSocketServerHandler;
import org.mockserver.echo.http.ErrorHandler;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

public class EchoServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final Configuration configuration;
    private final MockServerLogger mockServerLogger;
    private final boolean secure;
    private final EchoServer.Error error;
    private final List<TextWebSocketFrame> textWebSocketFrames;
    private final List<Channel> websocketChannels;
    private final List<String> registeredClients;
    private final SslContext sslContext;

    EchoServerInitializer(Configuration configuration, MockServerLogger mockServerLogger, boolean secure, SslContext sslContext, EchoServer.Error error, List<String> registeredClients, List<Channel> websocketChannels, List<TextWebSocketFrame> textWebSocketFrames) {
        this.configuration = configuration;
        this.mockServerLogger = mockServerLogger;
        this.secure = secure;
        this.sslContext = sslContext;
        if (!secure && error == EchoServer.Error.CLOSE_CONNECTION) {
            throw new IllegalArgumentException("Error type CLOSE_CONNECTION is not supported in non-secure mode");
        }
        this.error = error;
        this.registeredClients = registeredClients;
        this.websocketChannels = websocketChannels;
        this.textWebSocketFrames = textWebSocketFrames;
    }

    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.error != null) {
            pipeline.addLast(new ChannelHandler[]{new ErrorHandler(this.error)});
        }
        if (this.secure) {
            pipeline.addLast(new ChannelHandler[]{(this.sslContext != null ? this.sslContext : new NettySslContextFactory(this.configuration, this.mockServerLogger, true).createServerSslContext()).newHandler(channel.alloc())});
        }
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(EchoServer.class.getName() + " <-->")});
        }
        if (this.secure) {
            pipeline.addLast(new ChannelHandler[]{new EchoServerHttpOrHttp2Initializer(this.mockServerLogger, channel, this::configureHttp1Pipeline, this::configureHttp2Pipeline)});
        } else {
            this.configureHttp1Pipeline(channel, pipeline);
        }
    }

    private void configureHttp1Pipeline(SocketChannel channel, ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new EchoWebSocketServerHandler(this.mockServerLogger, this.registeredClients, this.websocketChannels, this.textWebSocketFrames, this.secure)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpServerCodec(this.configuration, this.mockServerLogger, this.secure, null, channel.localAddress().getPort())});
        pipeline.addLast(new ChannelHandler[]{new EchoServerHandler(this.error, this.mockServerLogger, (MockServerEventLog)channel.attr(EchoServer.LOG_FILTER).get(), (EchoServer.NextResponse)channel.attr(EchoServer.NEXT_RESPONSE).get(), (EchoServer.LastRequest)channel.attr(EchoServer.LAST_REQUEST).get())});
    }

    private void configureHttp2Pipeline(SocketChannel channel, ChannelPipeline pipeline) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        HttpToHttp2ConnectionHandlerBuilder http2ConnectionHandlerBuilder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(Integer.MAX_VALUE).propagateSettings(true).validateHttpHeaders(false).build())).connection((Http2Connection)connection);
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            http2ConnectionHandlerBuilder.frameLogger(new Http2FrameLogger(LogLevel.TRACE, EchoServerInitializer.class.getName()));
        }
        pipeline.addLast(new ChannelHandler[]{http2ConnectionHandlerBuilder.build()});
        pipeline.addLast(new ChannelHandler[]{new EchoWebSocketServerHandler(this.mockServerLogger, this.registeredClients, this.websocketChannels, this.textWebSocketFrames, this.secure)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpServerCodec(this.configuration, this.mockServerLogger, this.secure, null, channel.localAddress().getPort())});
        pipeline.addLast(new ChannelHandler[]{new EchoServerHandler(this.error, this.mockServerLogger, (MockServerEventLog)channel.attr(EchoServer.LOG_FILTER).get(), (EchoServer.NextResponse)channel.attr(EchoServer.NEXT_RESPONSE).get(), (EchoServer.LastRequest)channel.attr(EchoServer.LAST_REQUEST).get())});
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("echo server caught exception").setThrowable(cause));
        ctx.close();
    }
}

