/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import java.util.function.BiConsumer;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class EchoServerHttpOrHttp2Initializer
extends ApplicationProtocolNegotiationHandler {
    private final MockServerLogger mockServerLogger;
    private final SocketChannel channel;
    private final BiConsumer<SocketChannel, ChannelPipeline> http2Initializer;
    private final BiConsumer<SocketChannel, ChannelPipeline> http1Initializer;

    protected EchoServerHttpOrHttp2Initializer(MockServerLogger mockServerLogger, SocketChannel channel, BiConsumer<SocketChannel, ChannelPipeline> http1Initializer, BiConsumer<SocketChannel, ChannelPipeline> http2Initializer) {
        super("");
        this.mockServerLogger = mockServerLogger;
        this.channel = channel;
        this.http2Initializer = http2Initializer;
        this.http1Initializer = http1Initializer;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
        ChannelPipeline pipeline;
        if (MockServerLogger.isEnabled(Level.TRACE) && this.mockServerLogger != null) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("found ALPN protocol:{}").setArguments(protocol));
        }
        if ((pipeline = ctx.pipeline()).get(EchoServerHttpOrHttp2Initializer.class) != null) {
            pipeline.remove(EchoServerHttpOrHttp2Initializer.class);
        }
        if ("h2".equals(protocol)) {
            this.http2Initializer.accept(this.channel, pipeline);
        } else {
            this.http1Initializer.accept(this.channel, pipeline);
        }
    }
}

