/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import com.google.common.io.ByteStreams;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.InputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockserver.codec.BodyDecoderEncoder;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.streams.IOStreamUtils;
import org.slf4j.event.Level;

public class BodyServletDecoderEncoder {
    private final MockServerLogger mockServerLogger;
    private final IOStreamUtils ioStreamUtils;
    private final BodyDecoderEncoder bodyDecoderEncoder = new BodyDecoderEncoder();

    public BodyServletDecoderEncoder(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.ioStreamUtils = new IOStreamUtils(mockServerLogger);
    }

    public void bodyToServletResponse(HttpServletResponse httpServletResponse, Body body, String contentTypeHeader) {
        byte[] bytes = this.bodyDecoderEncoder.bodyToBytes(body, contentTypeHeader);
        if (bytes != null) {
            this.ioStreamUtils.writeToOutputStream(bytes, (ServletResponse)httpServletResponse);
        }
    }

    public BodyWithContentType servletRequestToBody(HttpServletRequest servletRequest) {
        if (servletRequest != null) {
            String contentTypeHeader = servletRequest.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
            try {
                byte[] bodyBytes = ByteStreams.toByteArray((InputStream)servletRequest.getInputStream());
                return this.bodyDecoderEncoder.bytesToBody(bodyBytes, contentTypeHeader);
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while reading HttpServletRequest input stream").setThrowable(throwable));
                throw new RuntimeException("IOException while reading HttpServletRequest input stream", throwable);
            }
        }
        return null;
    }
}

