/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.cache;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mockserver.cache.Entry;
import org.mockserver.logging.MockServerLogger;

public class LRUCache<K, V> {
    private static boolean allCachesEnabled = true;
    private static int maxSizeOverride = 0;
    private static final List<LRUCache<?, ?>> allCaches = new ArrayList();
    private final long ttlInMillis;
    private final int maxSize;
    private final ConcurrentHashMap<K, Entry<V>> map;
    private final ConcurrentLinkedQueue<K> queue;
    private final MockServerLogger mockServerLogger;

    public LRUCache(MockServerLogger mockServerLogger, int maxSize, long ttlInMillis) {
        this.mockServerLogger = mockServerLogger;
        this.maxSize = maxSize;
        this.map = new ConcurrentHashMap(maxSize);
        this.queue = new ConcurrentLinkedQueue();
        this.ttlInMillis = ttlInMillis;
        allCaches.add(this);
    }

    public static void allCachesEnabled(boolean enabled) {
        allCachesEnabled = enabled;
    }

    @VisibleForTesting
    public static void clearAllCaches() {
        for (LRUCache<?, ?> cache : allCaches) {
            if (cache == null) continue;
            super.clear();
        }
    }

    public void put(K key, V value) {
        this.put(key, value, this.ttlInMillis);
    }

    public void put(K key, V value, long ttl) {
        if (allCachesEnabled && key != null) {
            if (this.map.containsKey(key)) {
                this.queue.remove(key);
            }
            while (this.queue.size() >= this.maxSize || maxSizeOverride > 0 && this.queue.size() >= maxSizeOverride) {
                K oldestKey = this.queue.poll();
                if (null == oldestKey) continue;
                this.map.remove(oldestKey);
            }
            this.queue.add(key);
            this.map.put(key, new Entry<V>(ttl, this.expiryInMillis(ttl), value));
        }
    }

    private long expiryInMillis(long ttl) {
        return System.currentTimeMillis() + ttl;
    }

    public V get(K key) {
        if (allCachesEnabled && key != null) {
            Entry<V> entry;
            if (this.map.containsKey(key)) {
                this.queue.remove(key);
                this.queue.add(key);
            }
            if ((entry = this.map.get(key)) != null) {
                if (entry.getExpiryInMillis() > System.currentTimeMillis()) {
                    return entry.updateExpiryInMillis(this.expiryInMillis(entry.getTtlInMillis())).getValue();
                }
                this.delete(key);
            }
        }
        return null;
    }

    public void delete(K key) {
        if (allCachesEnabled && key != null && this.map.containsKey(key)) {
            this.map.remove(key);
            this.queue.remove(key);
        }
    }

    private void clear() {
        this.map.clear();
        this.queue.clear();
    }

    public static void setMaxSizeOverride(int maxSizeOverride) {
        LRUCache.maxSizeOverride = maxSizeOverride;
    }
}

