/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.utils;

import java.io.FilenameFilter;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.impl.services.rk.osgi.ClassTracker;
import org.jflux.impl.services.rk.osgi.OSGiUtils;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.library.AnimationLibrary;
import org.mechio.api.animation.library.AnimationLibraryLoader;
import org.mechio.api.animation.player.AnimationJob;
import org.mechio.api.animation.player.AnimationPlayer;
import org.mechio.api.animation.utils.AnimationEditListener;
import org.mechio.api.animation.utils.ChannelsParameterSource;
import org.mechio.api.animation.xml.AnimationFileReader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class AnimationUtils {
    private static final Logger theLogger = Logger.getLogger(AnimationUtils.class.getName());
    private static ClassTracker<ChannelsParameterSource> theChannelParamTracker;
    private static ClassTracker<AnimationEditListener> theListeners;

    private static ClassTracker<ChannelsParameterSource> getChanParamTracker() {
        if (theChannelParamTracker != null) {
            return theChannelParamTracker;
        }
        BundleContext context = OSGiUtils.getBundleContext(ChannelsParameterSource.class);
        if (context == null) {
            return null;
        }
        theChannelParamTracker = new ClassTracker(context, ChannelsParameterSource.class.getName(), null, null);
        return theChannelParamTracker;
    }

    public static ChannelsParameterSource getChannelsParameterSource() {
        ClassTracker<ChannelsParameterSource> tracker = AnimationUtils.getChanParamTracker();
        return tracker == null ? null : (ChannelsParameterSource)tracker.getTopService();
    }

    public static void writePositions(long x, Map<Integer, Double> channelPositions) {
        List<AnimationEditListener> listeners = AnimationUtils.getListeners();
        if (listeners == null) {
            return;
        }
        for (AnimationEditListener listener : listeners) {
            listener.handlePositions(x, channelPositions);
        }
    }

    private static List<AnimationEditListener> getListeners() {
        ClassTracker<AnimationEditListener> tracker = AnimationUtils.getAELTracker();
        return tracker == null ? null : tracker.getServices();
    }

    private static ClassTracker<AnimationEditListener> getAELTracker() {
        if (theListeners != null) {
            return theListeners;
        }
        BundleContext context = OSGiUtils.getBundleContext(AnimationEditListener.class);
        if (context == null) {
            return null;
        }
        theListeners = new ClassTracker(context, AnimationEditListener.class.getName(), null, null);
        return theListeners;
    }

    public static ServiceReference getAnimationPlayerReference(BundleContext context, String filter) {
        if (context == null) {
            throw new NullPointerException();
        }
        ServiceReference[] refs = null;
        try {
            refs = context.getServiceReferences(AnimationPlayer.class.getName(), filter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Invlaid filter: " + filter + ".  Could not fetch AnimationPlayer.", ex);
        }
        if (refs == null) {
            theLogger.log(Level.WARNING, "Could not find AnimationPlayer");
            return null;
        }
        return refs[0];
    }

    public static AnimationJob playAnimation(BundleContext context, String filter, Animation anim) {
        return AnimationUtils._playAnimation(context, filter, anim, null, null);
    }

    public static AnimationJob playAnimation(BundleContext context, String filter, Animation anim, long startTime, long stopTime) {
        return AnimationUtils._playAnimation(context, filter, anim, startTime, stopTime);
    }

    private static AnimationJob _playAnimation(BundleContext context, String filter, Animation anim, Long startTime, Long stopTime) {
        if (context == null || anim == null) {
            throw new NullPointerException();
        }
        ServiceReference ref = AnimationUtils.getAnimationPlayerReference(context, filter);
        if (ref == null) {
            return null;
        }
        Object obj = context.getService(ref);
        if (obj == null || !(obj instanceof AnimationPlayer)) {
            context.ungetService(ref);
            return null;
        }
        AnimationPlayer player = (AnimationPlayer)obj;
        AnimationJob job = null;
        if (player != null) {
            job = startTime != null && stopTime != null ? player.playAnimation(anim, startTime, stopTime) : player.playAnimation(anim);
        }
        context.ungetService(ref);
        return job;
    }

    public static AnimationLibrary loadAnimationLibrary(BundleContext context, String libraryId, String animationPath, boolean recursive, FilenameFilter filenameFilter) {
        if (context == null || animationPath == null) {
            throw new NullPointerException();
        }
        ServiceReference ref = context.getServiceReference(AnimationFileReader.class.getName());
        if (ref == null) {
            throw new NullPointerException();
        }
        Object obj = context.getService(ref);
        if (obj == null) {
            throw new NullPointerException();
        }
        AnimationFileReader reader = (AnimationFileReader)obj;
        AnimationLibraryLoader fact = new AnimationLibraryLoader();
        AnimationLibrary library = AnimationLibraryLoader.loadAnimationFolder(libraryId, reader, animationPath, recursive);
        return library;
    }

    public static ServiceRegistration registerAnimationLibrary(BundleContext context, AnimationLibrary library, Properties serviceProps) {
        String filter;
        if (context == null) {
            throw new NullPointerException();
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (serviceProps != null) {
            for (Object prop : serviceProps.keySet()) {
                ((Dictionary)props).put(prop.toString(), serviceProps.get(prop));
            }
        }
        if (OSGiUtils.serviceExists((BundleContext)context, AnimationLibrary.class, (String)(filter = OSGiUtils.createServiceFilter((Properties)serviceProps))).booleanValue()) {
            theLogger.log(Level.WARNING, "Unable to register AnimationLibrary.  AnimationLibrary with filter: {0}, already exists.", filter);
            return null;
        }
        ServiceRegistration reg = context.registerService(AnimationLibrary.class.getName(), (Object)library, props);
        return reg;
    }

    public static void addAnimationToLibrary(BundleContext context, Animation animation, String filter) {
        ServiceReference[] refs;
        if (context == null || animation == null) {
            throw new NullPointerException();
        }
        try {
            refs = context.getServiceReferences(AnimationLibrary.class.getName(), filter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Bad filter: " + filter, ex);
            return;
        }
        if (refs == null || refs.length == 0) {
            theLogger.log(Level.WARNING, "Could not find AnimationLibrary matching: {0}", filter);
            return;
        }
        ServiceReference ref = refs[0];
        Object obj = context.getService(ref);
        if (obj == null || !(obj instanceof AnimationLibrary)) {
            theLogger.warning("Error retieving AnimationLibrary Service.");
            return;
        }
        AnimationLibrary lib = (AnimationLibrary)obj;
        lib.add(animation);
    }

    public static Animation fetchAnimation(BundleContext context, VersionProperty animVersion, String filter) {
        ServiceReference[] refs;
        if (context == null || animVersion == null) {
            throw new NullPointerException();
        }
        try {
            refs = context.getServiceReferences(AnimationLibrary.class.getName(), filter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Bad filter: " + filter, ex);
            return null;
        }
        if (refs == null || refs.length == 0) {
            theLogger.log(Level.WARNING, "Could not find AnimationLibrary matching: {0}", filter);
            return null;
        }
        ServiceReference ref = refs[0];
        Object obj = context.getService(ref);
        if (obj == null || !(obj instanceof AnimationLibrary)) {
            theLogger.warning("Error retieving AnimationLibrary Service.");
            return null;
        }
        AnimationLibrary lib = (AnimationLibrary)obj;
        return lib.getAnimation(animVersion);
    }

    public static Animation fetchAnimation(BundleContext context, String animVersionName, String filter) {
        ServiceReference[] refs;
        if (context == null || animVersionName == null) {
            throw new NullPointerException();
        }
        try {
            refs = context.getServiceReferences(AnimationLibrary.class.getName(), filter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Bad filter: " + filter, ex);
            return null;
        }
        if (refs == null || refs.length == 0) {
            theLogger.log(Level.WARNING, "Could not find AnimationLibrary matching: {0}", filter);
            return null;
        }
        ServiceReference ref = refs[0];
        Object obj = context.getService(ref);
        if (obj == null || !(obj instanceof AnimationLibrary)) {
            theLogger.warning("Error retieving AnimationLibrary Service.");
            return null;
        }
        AnimationLibrary lib = (AnimationLibrary)obj;
        List<VersionProperty> properties = lib.getAnimationVersions();
        for (VersionProperty property : properties) {
            if (!animVersionName.equals(property.getName())) continue;
            return lib.getAnimation(property);
        }
        return null;
    }
}

