/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.editor;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jflux.api.common.rk.localization.Localizer;
import org.jflux.api.common.rk.utils.RKSource;
import org.mechio.api.animation.Channel;
import org.mechio.api.animation.MotionPath;
import org.mechio.api.animation.compiled.CompiledPath;
import org.mechio.api.animation.editor.AbstractEditor;
import org.mechio.api.animation.editor.EditState;
import org.mechio.api.animation.editor.MotionPathEditor;
import org.mechio.api.animation.editor.history.HistoryHelper;
import org.mechio.api.animation.editor.history.HistoryStack;
import org.mechio.api.animation.utils.AnimationUtils;
import org.mechio.api.animation.utils.ChannelsParameter;
import org.mechio.api.animation.utils.ChannelsParameterSource;

public class ChannelEditor
extends AbstractEditor<MotionPath, MotionPathEditor> {
    private Channel myChannel;
    private Channel myChannelView;
    private Color myColor;
    private static Map<Integer, Color> theColorMap;

    public ChannelEditor(Channel channel, HistoryStack hist) {
        super(hist);
        this.myChannel = channel;
        this.setChildren(this.myChannel.getMotionPaths());
        this.updateView();
    }

    @Override
    protected MotionPath removeChild(Object invoker, int i) {
        MotionPath mp = this.myChannel.removeMotionPath(i);
        this.updateView();
        return mp;
    }

    private void updateView() {
        this.myChannelView = new Channel(this.myChannel.getId(), this.myChannel.getName());
        for (int i = 0; i < this.myChannel.getMotionPaths().size(); ++i) {
            if (((MotionPathEditor)((Object)this.getChild(i))).hasFlag(EditState.DISABLED)) continue;
            MotionPath mp = this.myChannel.getMotionPath(i);
            this.myChannelView.addPath(mp);
        }
    }

    protected Channel getChannelView() {
        if (this.myChannelView == null) {
            this.updateView();
        }
        return this.myChannelView;
    }

    public CompiledPath getCompiledPath(long start, long end, long stepLength) {
        return this.getChannelView().compilePath(start, end, stepLength);
    }

    public List<Point2D> getInterpolatedPoints() {
        return this.getChannelView().getInterpolatedPoints(-1L, -1L);
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        String oldName = this.myChannel.getName();
        this.myChannel.setName(name);
        this.firePropertyChange("name", oldName, name);
    }

    @Override
    public String getName() {
        String name = this.myChannel.getName();
        if (name == null || name.isEmpty()) {
            ChannelsParameterSource paramSource = AnimationUtils.getChannelsParameterSource();
            if (paramSource != null) {
                for (ChannelsParameter channel : paramSource.getChannelParameters()) {
                    if (channel.getChannelID() != this.myChannel.getId().intValue()) continue;
                    name = channel.getChannelName();
                    break;
                }
            }
            if (name == null || name.isEmpty()) {
                return Localizer.$_((String)"channel") + this.myChannel.getId();
            }
            return name;
        }
        return this.myChannel.getName();
    }

    public Color getPrimaryColor() {
        if (this.myColor == null) {
            this.myColor = ChannelEditor.getChannelColor(this.myChannel.getId());
        }
        return this.myColor;
    }

    public static Color getChannelColor(Integer i) {
        Color col;
        if (i == null) {
            return Color.black;
        }
        if (theColorMap == null) {
            theColorMap = new HashMap<Integer, Color>();
            int k = 0;
            theColorMap.put(k++, Color.decode("#eea31f"));
            theColorMap.put(k++, Color.decode("#FF0000"));
            theColorMap.put(k++, Color.decode("#00b8ff"));
            theColorMap.put(k++, Color.decode("#029b0e"));
            theColorMap.put(k++, Color.decode("#0000ee"));
            theColorMap.put(k++, Color.decode("#E01BD9"));
            theColorMap.put(k++, Color.decode("#1BE0D6"));
            theColorMap.put(k++, Color.decode("#334710"));
            theColorMap.put(k++, Color.decode("#703914"));
            theColorMap.put(k++, Color.decode("#029b0e"));
            theColorMap.put(k++, Color.decode("#009900"));
            theColorMap.put(k++, Color.decode("#000044"));
        }
        if ((col = theColorMap.get(i % theColorMap.size())) == null) {
            theColorMap.put(i, Color.red);
            return Color.red;
        }
        return col;
    }

    public void setPrimaryColor(Object invoker, Color col) {
        Color prev = this.getPrimaryColor();
        this.myColor = col;
        if (invoker != this.mySharedHistory) {
            this.mySharedHistory.addEvent(HistoryHelper.changeColor(this, col, prev));
        }
        this.fireStructureChangedEvent(invoker);
    }

    public long getEnd() {
        long end = 0L;
        for (MotionPathEditor mpc : this.myChildren) {
            long nEnd = (long)mpc.getEnd();
            if (nEnd <= end) continue;
            end = nEnd;
        }
        return end;
    }

    public long getStart() {
        long start = -1L;
        for (MotionPathEditor mpc : this.myChildren) {
            long nStart = (long)mpc.getStart();
            if (nStart >= start && start != -1L) continue;
            start = nStart;
        }
        return start;
    }

    protected void setEnabled(MotionPath mp, boolean enabled) {
        if (!enabled) {
            this.getChannelView().removeMotionPath(mp);
        } else {
            this.updateView();
        }
    }

    @Override
    protected MotionPathEditor createChildController(MotionPath path) {
        return new MotionPathEditor(path, this.mySharedHistory);
    }

    @Override
    public boolean isChildUIController() {
        return true;
    }

    @Override
    protected int addChildBase(Object invoker, RKSource<MotionPath> pathSource, int i) {
        this.myChannel.addPath(i, (MotionPath)pathSource.getValue());
        return this.myChannel.getMotionPaths().indexOf(pathSource.getValue());
    }

    @Override
    protected int insertChildControllerBase(MotionPathEditor controller, int i) {
        MotionPath path = controller.getMotionPath();
        this.myChannel.addPath(i, path);
        i = this.myChannel.getMotionPaths().indexOf(path);
        return i;
    }

    @Override
    protected void afterAddChild() {
        this.updateView();
    }

    protected Channel getChannel() {
        return this.myChannel;
    }

    public int getId() {
        return this.myChannel.getId();
    }
}

