/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.util.ServerPrepareResult;

public class PrepareCache
extends LinkedHashMap<String, ServerPrepareResult> {
    private static final long serialVersionUID = -8922905563713952695L;
    private final int maxSize;
    private final Client client;

    public PrepareCache(int size, Client client) {
        super(size, 0.75f, true);
        this.maxSize = size;
        this.client = client;
    }

    @Override
    public boolean removeEldestEntry(Map.Entry<String, ServerPrepareResult> eldest) {
        if (this.size() > this.maxSize) {
            eldest.getValue().unCache(this.client);
            return true;
        }
        return false;
    }

    @Override
    public synchronized ServerPrepareResult put(String key, ServerPrepareResult result) {
        ServerPrepareResult cached = (ServerPrepareResult)super.get(key);
        if (cached != null) {
            cached.incrementUse();
            result.unCache(this.client);
            return cached;
        }
        if (result.cache()) {
            super.put(key, result);
        }
        return null;
    }
}

