/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;
import org.mariadb.r2dbc.message.client.HandshakeResponse;
import org.mariadb.r2dbc.message.server.InitialHandshakePacket;
import reactor.core.publisher.Mono;

public final class SslRequestPacket
implements ClientMessage {
    private final InitialHandshakePacket initialHandshakePacket;
    private final long clientCapabilities;

    public SslRequestPacket(InitialHandshakePacket initialHandshakePacket, long clientCapabilities) {
        this.initialHandshakePacket = initialHandshakePacket;
        this.clientCapabilities = clientCapabilities;
    }

    @Override
    public Mono<ByteBuf> encode(Context context, ByteBufAllocator allocator) {
        byte exchangeCharset = HandshakeResponse.decideLanguage(this.initialHandshakePacket.getDefaultCollation(), this.initialHandshakePacket.getMajorServerVersion(), this.initialHandshakePacket.getMinorServerVersion());
        ByteBuf buf = allocator.buffer(32, 32);
        buf.writeIntLE((int)this.clientCapabilities);
        buf.writeIntLE(0x40000000);
        buf.writeByte((int)exchangeCharset);
        buf.writeZero(19);
        buf.writeIntLE((int)(this.clientCapabilities >> 32));
        return Mono.just((Object)buf);
    }

    @Override
    public MessageSequence getSequencer() {
        return this.initialHandshakePacket.getSequencer();
    }
}

