/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.list.LocalDateCodec;
import org.mariadb.r2dbc.codec.list.LocalDateTimeCodec;
import org.mariadb.r2dbc.codec.list.LocalTimeCodec;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;

public class InstantCodec
implements Codec<Instant> {
    public static final InstantCodec INSTANCE = new InstantCodec();
    public static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    public static final DateTimeFormatter TIMESTAMP_FORMAT_NO_FRACTIONAL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATETIME, new DataType[]{DataType.TIMESTAMP, DataType.VARSTRING, DataType.TEXT, DataType.STRING, DataType.TIME, DataType.DATE});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && type.isAssignableFrom(Instant.class);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Instant.class.isAssignableFrom(value);
    }

    @Override
    public Instant decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Instant> type, ExceptionFactory factory) {
        switch (column.getDataType()) {
            case DATE: {
                int[] parts = LocalDateCodec.parseDate(buf, length);
                if (parts == null) {
                    return null;
                }
                return LocalDateTime.of(parts[0], parts[1], parts[2], 0, 0, 0).atZone(ZoneId.systemDefault()).toInstant();
            }
            case DATETIME: 
            case TIMESTAMP: {
                int[] parts = LocalDateTimeCodec.parseTimestamp(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
                if (parts == null) {
                    return null;
                }
                return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]).atZone(ZoneId.systemDefault()).toInstant();
            }
            case TIME: {
                int[] parts = LocalTimeCodec.parseTime(buf, length, column, factory);
                return LocalDateTime.of(1970, 1, 1, parts[1] % 24, parts[2], parts[3]).plusNanos(parts[4]).atZone(ZoneId.systemDefault()).toInstant();
            }
        }
        String val = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        try {
            int[] parts = LocalDateTimeCodec.parseTimestamp(val);
            if (parts == null) {
                return null;
            }
            return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]).atZone(ZoneId.systemDefault()).toInstant();
        }
        catch (DateTimeException dte) {
            throw factory.createParsingException(String.format("value '%s' (%s) cannot be decoded as LocalDateTime", new Object[]{val, column.getDataType()}));
        }
    }

    @Override
    public Instant decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Instant> type, ExceptionFactory factory) {
        int year = 1970;
        byte month = 1;
        long dayOfMonth = 1L;
        byte hour = 0;
        int minutes = 0;
        int seconds = 0;
        long microseconds = 0L;
        switch (column.getDataType()) {
            case TIME: {
                if (length <= 0) break;
                buf.skipBytes(5);
                hour = buf.readByte();
                minutes = buf.readByte();
                seconds = buf.readByte();
                if (length <= 8) break;
                microseconds = buf.readUnsignedIntLE();
                break;
            }
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: {
                if (length > 0) {
                    year = buf.readUnsignedShortLE();
                    month = buf.readByte();
                    dayOfMonth = buf.readByte();
                    if (length > 4) {
                        hour = buf.readByte();
                        minutes = buf.readByte();
                        seconds = buf.readByte();
                        if (length > 7) {
                            microseconds = buf.readUnsignedIntLE();
                        }
                    }
                    if (year != 0 || month != 0 || dayOfMonth != 0L || hour != 0 || minutes != 0 || seconds != 0) break;
                    return null;
                }
                return null;
            }
            default: {
                String val = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    int[] parts = LocalDateTimeCodec.parseTimestamp(val);
                    if (parts == null) {
                        return null;
                    }
                    return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]).atZone(ZoneId.systemDefault()).toInstant();
                }
                catch (DateTimeException dte) {
                    throw factory.createParsingException(String.format("value '%s' (%s) cannot be decoded as LocalDateTime", new Object[]{val, column.getDataType()}));
                }
            }
        }
        return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, minutes, seconds).plusNanos(microseconds * 1000L).atZone(ZoneId.systemDefault()).toInstant();
    }

    @Override
    public void encodeDirectText(ByteBuf out, Object value, Context context) {
        Instant val = (Instant)value;
        LocalDateTime ldt = LocalDateTime.ofInstant(val, ZoneId.systemDefault());
        out.writeByte(39);
        out.writeCharSequence((CharSequence)ldt.format(ldt.getNano() != 0 ? LocalDateTimeCodec.TIMESTAMP_FORMAT : LocalDateTimeCodec.TIMESTAMP_FORMAT_NO_FRACTIONAL), StandardCharsets.US_ASCII);
        out.writeByte(39);
    }

    @Override
    public void encodeDirectBinary(ByteBufAllocator allocator, ByteBuf out, Object value, Context context) {
        Instant val = (Instant)value;
        LocalDateTime ldt = LocalDateTime.ofInstant(val, ZoneId.systemDefault());
        int nano = ldt.getNano();
        if (nano > 0) {
            out.writeByte(11);
            out.writeShortLE((int)((short)ldt.getYear()));
            out.writeByte(ldt.getMonthValue());
            out.writeByte(ldt.getDayOfMonth());
            out.writeByte(ldt.getHour());
            out.writeByte(ldt.getMinute());
            out.writeByte(ldt.getSecond());
            out.writeIntLE(nano / 1000);
        } else {
            out.writeByte(7);
            out.writeShortLE((int)((short)ldt.getYear()));
            out.writeByte(ldt.getMonthValue());
            out.writeByte(ldt.getDayOfMonth());
            out.writeByte(ldt.getHour());
            out.writeByte(ldt.getMinute());
            out.writeByte(ldt.getSecond());
        }
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.DATETIME;
    }
}

