/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcTransientResourceException;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.client.MariadbOutParametersMetadata;
import org.mariadb.r2dbc.client.MariadbRow;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.Assert;
import reactor.util.annotation.Nullable;

public class MariadbOutParameters
implements org.mariadb.r2dbc.api.MariadbOutParameters {
    protected static final int NULL_LENGTH = -1;
    protected final MariadbOutParametersMetadata meta;
    protected final ByteBuf buf;
    protected final ExceptionFactory factory;
    private final int columnNumber;
    private final byte[] nullBitmap;
    protected int length;
    protected int index = -1;

    public MariadbOutParameters(ByteBuf buf, MariadbOutParametersMetadata meta, ExceptionFactory factory) {
        this.buf = buf;
        this.meta = meta;
        this.factory = factory;
        this.columnNumber = meta.getParameterMetadatas().size();
        this.nullBitmap = new byte[(this.columnNumber + 9) / 8];
        buf.skipBytes(1);
        buf.readBytes(this.nullBitmap);
        buf.markReaderIndex();
    }

    @Nullable
    public <T> T get(int index, Class<T> type) {
        if ((this.nullBitmap[(index + 2) / 8] & 1 << (index + 2) % 8) != 0) {
            if (type != null && type.isPrimitive()) {
                throw new R2dbcTransientResourceException(String.format("Cannot return null for primitive %s", type.getName()));
            }
            return null;
        }
        ColumnDefinitionPacket column = this.meta.getParameterMetadata(index);
        this.setPosition(index);
        if (this.length == -1) {
            if (type.isPrimitive()) {
                throw new R2dbcTransientResourceException(String.format("Cannot return null for primitive %s", type.getName()));
            }
            return null;
        }
        if (Object.class == type || type == null) {
            Codec<?> defaultCodec = column.getType().getDefaultCodec();
            return (T)defaultCodec.decodeBinary(this.buf, this.length, column, type, this.factory);
        }
        for (Codec<T> codec : Codecs.LIST) {
            if (!codec.canDecode(column, type)) continue;
            return (T)codec.decodeBinary(this.buf, this.length, column, type, this.factory);
        }
        this.buf.skipBytes(this.length);
        throw MariadbRow.noDecoderException(column, type);
    }

    @Nullable
    public <T> T get(String name, Class<T> type) {
        Assert.requireNonNull(name, "name must not be null");
        return this.get(this.meta.getIndex(name), type);
    }

    public void setPosition(int newIndex) {
        if (this.index >= newIndex) {
            this.index = 0;
            this.buf.resetReaderIndex();
        } else {
            ++this.index;
        }
        while (this.index < newIndex) {
            if ((this.nullBitmap[(this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                block0 : switch (this.meta.getParameterMetadata(this.index).getDataType()) {
                    case BIGINT: 
                    case DOUBLE: {
                        this.buf.skipBytes(8);
                        break;
                    }
                    case INTEGER: 
                    case MEDIUMINT: 
                    case FLOAT: {
                        this.buf.skipBytes(4);
                        break;
                    }
                    case SMALLINT: 
                    case YEAR: {
                        this.buf.skipBytes(2);
                        break;
                    }
                    case TINYINT: {
                        this.buf.skipBytes(1);
                        break;
                    }
                    default: {
                        short type = this.buf.readUnsignedByte();
                        switch (type) {
                            case 251: {
                                break block0;
                            }
                            case 252: {
                                this.buf.skipBytes(this.buf.readUnsignedShortLE());
                                break block0;
                            }
                            case 253: {
                                this.buf.skipBytes(this.buf.readUnsignedMediumLE());
                                break block0;
                            }
                            case 254: {
                                this.buf.skipBytes((int)this.buf.readLongLE());
                                break block0;
                            }
                        }
                        this.buf.skipBytes((int)type);
                    }
                }
            }
            ++this.index;
        }
        switch (this.meta.getParameterMetadata(this.index).getDataType()) {
            case BIGINT: 
            case DOUBLE: {
                this.length = 8;
                return;
            }
            case INTEGER: 
            case MEDIUMINT: 
            case FLOAT: {
                this.length = 4;
                return;
            }
            case SMALLINT: 
            case YEAR: {
                this.length = 2;
                return;
            }
            case TINYINT: {
                this.length = 1;
                return;
            }
        }
        short len = this.buf.readUnsignedByte();
        switch (len) {
            case 252: {
                this.length = this.buf.readUnsignedShortLE();
                return;
            }
            case 253: {
                this.length = this.buf.readUnsignedMediumLE();
                return;
            }
            case 254: {
                this.length = (int)this.buf.readLongLE();
                return;
            }
        }
        this.length = len;
    }

    @Override
    public MariadbOutParametersMetadata getMetadata() {
        return this.meta;
    }
}

